<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\ShortcodeRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class ShortcodeCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class ShortcodeCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Shortcode::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/shortcode');
        CRUD::setEntityNameStrings('shortcode', 'shortcodes');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        // CRUD::setFromDb(); // set columns from db columns.

        CRUD::column('name');
        // CRUD::column('content_text');
        CRUD::column('heading');
        CRUD::column('content');
        CRUD::column('button_text');
        CRUD::column('link');

        /**
         * Columns can be defined using the fluent syntax:
         * - CRUD::column('price')->type('number');
         */
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(ShortcodeRequest::class);
        // CRUD::setFromDb(); // set fields from db columns.

        // CRUD::field('name')->type('text')->label('Short code name');
        CRUD::field([   // Text
            'name'  => 'name',
            'label' => "Short Code Name",
            'type'  => 'text',
        ]);
        // CRUD::field('content')->type('text');
        // CRUD::field([   // select_from_array
        //     'name'        => 'type',
        //     'label'       => "Short Code type",
        //     'type'        => 'select_from_array',
        //     'options'     => ['one' => '1', 'two' => '2', 'three' => '3'],
        //     'allows_null' => false,
        //     'default'     => 'one',
        //     // 'allows_multiple' => true, // OPTIONAL; needs you to cast this to array in your model;
        // ]);
        
        CRUD::field('heading')->type('text');
        
        CRUD::field('content')->type('text');
        
        CRUD::field('button_text')->type('text');
        
        CRUD::field('link')->type('text');

        // CRUD::field([   // repeatable
        //     'name'  => 'content_text',
        //     'label' => 'content_text',
        //     'type'  => 'repeatable',
        //     'subfields' => [ // also works as: "fields"
        //         [
        //             'name'    => 'sub_name',
        //             'type'    => 'text',
        //             'label'   => 'sub_name',
        //             'wrapper' => ['class' => 'form-group col-md-4'],
        //         ],
        //         [
        //             'name'    => 'sub_content',
        //             'type'    => 'text',
        //             'label'   => 'sub_content',
        //             'wrapper' => ['class' => 'form-group col-md-12'],
        //         ],
        //     ],
        // ]);

        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
