<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('practice_areas_faqs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('practice_area_id');
            $table->longtext('title');
            $table->longtext('answer');
            $table->timestamps();
        });

        Schema::create('counties_faqs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('county_id');
            $table->longtext('title');
            $table->longtext('answer');
            $table->timestamps();
        });

        Schema::create('states_faqs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('state_id');
            $table->longtext('title');
            $table->longtext('answer');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('practice_areas_faqs');
	Schema::dropIfExists('counties_faqs');
	Schema::dropIfExists('states_faqs');

    }
};
