<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('practice_area_state_city_content', function (Blueprint $table) {
            $table->id();
            $table->text('url_index')->default("no")->nullable();
            $table->integer('practiceArea')->unsigned();
            $table->integer('state')->unsigned();
            $table->integer('county')->unsigned();
            $table->longText('short_content')->nullable();
            $table->longText('h2_after_s_c')->nullable();
            $table->longText('full_content')->nullable();
            $table->longText('extras')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
