jQuery(document).ready(function(){
    // HIDE ERRORS ON LOAD
    jQuery(".err").text("");
    jQuery(".err").fadeOut();
    jQuery(".form_res").fadeOut();
    jQuery(".form_res #form_loading").fadeOut();
    jQuery(".form_res #l_form_message").fadeOut();

    function errorFadeIn(text,ele) {
        jQuery(ele).parent().find(".err").fadeIn();
        jQuery(".err").css("color", "#b70c0c");
        jQuery(ele).parent().find(".err").text(text);
        setTimeout(() => {
            jQuery(".err").fadeOut();
        }, 5000);
        return false;
    }

    function errorFadeOut() {
        jQuery(".err").fadeOut();
        jQuery(".err").css("color", "#fff");
        jQuery(".err").text("");
    }

    // CHECK IS EMAIL
    function isEmail(email) {
        var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return regex.test(email);
    }

    // ON SUBMIT
    $("#ref_form_submit").click(function (e) {
        e.preventDefault();
        var email = $("#ref_email").val();
        var cur_u_id = $("#cur_u_id").val();

        const formData = new FormData();
        formData.append("ref_email", $("#ref_email").val());
        formData.append("cur_u_id", $("#cur_u_id").val());
        formData.append("referral_url", $("#referral_url").val());
        formData.append("cur_u_name", $("#cur_u_name").val());

        if (email.length == 0) {
            errorFadeIn("Enter your email addresss","#ref_email");
        }else if(!isEmail(email)){
            errorFadeIn("Enter valid email addresss","#ref_email");
        }else{
            errorFadeOut();

            jQuery("form").css("opacity", "0.8");
            ajaxSend(formData, referalURL);
        }
    });

    function ajaxSend(data, url) {
        $.ajaxSetup({
            headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        });
        $("#ref_form_submit").attr("disabled", true);
        $.ajax({
            url: url,
            type: "POST",
            data: data,
            processData: false,
            contentType: false,
            success: function (response) {
                var response = JSON.parse(response);
                jQuery("form").css("opacity", "1");

                if(response.error == ""){
                    jQuery("#l_form_message").text(response.success);
                    jQuery("#l_form_message").fadeIn();

                    setTimeout(function(){ 
                        jQuery("#l_form_message").text("");
                        jQuery("#l_form_message").fadeOut();
                    }, 2000);
                }else{
                    $("#ref_form_submit").attr("disabled", false);
                    jQuery(".form_res").fadeOut();
                    jQuery("#l_form_message").text(response.error);
                }
            },
        });
    }

});