function bpFieldInitPhoneElement(element) {
    let $phoneConfig = element.data('config');

    var input = element[0];
    var countryCode = 'us';

    if($phoneConfig.shouldDoGeoIpLookup) {
        $phoneConfig.geoIpLookup = function(success, failure) {
            $.get('https://ipinfo.io', function() {}, 'jsonp').always(function(resp) {
                countryCode = (resp && resp.country) ? resp.country : countryCode;
                success(countryCode);
            });
        }
    }

    /* Init phone object */
    var iti = window.intlTelInput(input, $phoneConfig);

    iti.promise.then(function() {
        // if the phone input is empty, let's at least select the prefix to the IP country
        if ($phoneConfig.shouldDoGeoIpLookup && input.value.trim().length <= 0) {
            iti.setCountry(countryCode);
        }

        //Fix error classes
        if(element.parent().find('.invalid-feedback').length > 0) {
            let error = element.parent().find('.invalid-feedback');
            $(error).appendTo(element.parent().parent());
            element.parent().find('.invalid-feedback').remove();
            element.parent().removeClass('text-danger');
            element.parent().parent().addClass('text-danger');
        }
    });
}

        