jQuery(document).ready(function(){
	// HIDE ERRORS ON LOAD
	jQuery(".err").text("");
	jQuery(".err").fadeOut();
	jQuery(".form_res").fadeOut();
	jQuery(".form_res #form_loading").fadeOut();
	jQuery(".form_res #l_form_message").fadeOut();

	function errorFadeIn(text,ele) {
		jQuery(ele).parent().find(".err").fadeIn();
		jQuery(".err").css("color", "#b70c0c");
		jQuery(ele).parent().find(".err").html(text);
		setTimeout(() => {
			jQuery(".err").fadeOut();
		}, 5000);
		return false;
	}

	function errorFadeOut() {
		jQuery(".err").fadeOut();
		jQuery(".err").css("color", "#fff");
		jQuery(".err").text("");
	}

	// CHECK IS EMAIL
	function isEmail(email) {
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		return regex.test(email);
	}

	// SHOW HIDE PASSWORD
	jQuery('#l_pass_view').click(function(){
		if('password' == jQuery('#l_password').attr('type')){
			jQuery('#l_password').prop('type', 'text');
		}else{
			jQuery('#l_password').prop('type', 'password');
		}
	});

	// PHONE INPUT
	jQuery('#l_phone').on('propertychange input', function (e) {
		var x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
		e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
	});

	// FORM SUBMISSION
	$("#l_get_listed_submit").click(function (e) {
		e.preventDefault();
		$("#l_get_listed").submit();
	});

	$("#l_get_listed").submit(function (e) {
		e.preventDefault();
		var first_name = $("#l_first_name").val();
		var last_name = $("#l_last_name").val();
		var email = $("#l_email").val();
		var phone = $("#l_phone").val();
		var password = $("#l_password").val();
		var list_id = $("#list_id").val();

		if (first_name.length == 0 || first_name.length < 2) {
			errorFadeIn("Enter valid first name. It should be 3 character long","#l_first_name");
		} else if (last_name.length == 0 || last_name.length < 2) {
			errorFadeIn("Enter valid last name. It should be 3 character long","#l_last_name");
		}else if (email.length == 0) {
			errorFadeIn("Enter your email addresss","#l_email");
		}else if(!isEmail(email)){
			errorFadeIn("Enter valid email addresss","#l_email");
		}else if (phone.length == 0 || phone.length < 3) {
			errorFadeIn("Enter valid phone","#l_phone");
		}else if (password.length == 0 || password.length < 5) {
			errorFadeIn("Enter valid password. It should be 4 character long","#l_password");
		}else {
			errorFadeOut(".error");
			jQuery(".form_res").fadeIn();
			jQuery(".form_res #form_loading").fadeIn();

			$("#l_get_listed").css("opacity", "0.8");
			const formData = new FormData();
			formData.append("first_name", $("#l_first_name").val());
			formData.append("last_name", $("#l_last_name").val());
			formData.append("email", $("#l_email").val());
			formData.append("phone", $("#l_phone").val());
			formData.append("password", $("#l_password").val());
			formData.append("list_id", list_id);
			ajaxSend(formData, lawyer_register);
		}
	});

	function ajaxSend(data, url) {
		$.ajaxSetup({
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		});
		$("#l_get_listed_submit").attr("disabled", true);
		$.ajax({
			url: url,
			type: "POST",
			data: data,
			processData: false,
			contentType: false,
			success: function (response) {
				var response = JSON.parse(response);

				jQuery(".form_res #form_loading").fadeOut();

				if(response.error == ""){
					jQuery(".form_res #l_form_message").text(response.success);
					jQuery(".form_res #l_form_message").fadeIn();

					setTimeout(function(){ 
						jQuery(".err").text("");
						jQuery(".err").fadeOut();
						jQuery("#h_login_form .form_res").fadeOut();
						jQuery("#h_login_form .form_res #l_form_message").text("");
						jQuery("#h_login_form .form_res #l_form_message").fadeOut();
						jQuery("a.login-btn").click();
					}, 2000);
				}else{
					$("#l_get_listed_submit").attr("disabled", false);
					jQuery("#l_get_listed").css("opacity", "1");
					jQuery(".form_res").fadeOut();

					if(response.e_code == "e_exists"){
						errorFadeIn(response.error,"#l_email");
					}
				}
			},
		});
	}

	// RESEND VERIFICATION EMAIL
	jQuery("body").on("click change", "#resend_verification", function (e) {
		e.preventDefault();

		$.ajaxSetup({
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		});
		const formData = new FormData();
		formData.append("email", $("#l_get_listed #l_email").val());

		$.ajax({
			url: r_verify,
			type: "POST",
			data: formData,
			processData: false,
			contentType: false,
			success: function (response) {
				var response = JSON.parse(response);

				if(response.error == ""){
					errorFadeIn(response.message,"#l_email");
				}else{
					jQuery("#l_get_listed").css("opacity", "1");
					jQuery(".form_res").fadeOut();

					if(response.e_code == "e"){
						errorFadeIn(response.error,"#l_email");
					}
				}
			},
		});
	});
});