<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_verification_documents', function (Blueprint $table) {
            $table->unsignedBigInteger('verified_by_user_id')->nullable();
            $table->foreign('verified_by_user_id')->references('id')->on('users');
            // Adding verified_at as a timestamp
            $table->timestamp('verified_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_verification_documents', function (Blueprint $table) {
            $table->dropForeign(['verified_by_user_id']);
            $table->dropColumn('verified_by_user_id');

            // Drop the verified_at column
            $table->dropColumn('verified_at');
        });
    }
};
