function bpFieldInitBase64CropperImageElement(element) {
        // Find DOM elements under this form-group element
        var $mainImage = element.find('[data-handle=mainImage]');
        var $uploadImage = element.find("[data-handle=uploadImage]");
        var $hiddenImage = element.find("[data-handle=hiddenImage]");
        var $hiddenFilename = element.find(".hiddenFilename");
        var $rotateLeft = element.find("[data-handle=rotateLeft]");
        var $rotateRight = element.find("[data-handle=rotateRight]");
        var $zoomIn = element.find("[data-handle=zoomIn]");
        var $zoomOut = element.find("[data-handle=zoomOut]");
        var $reset = element.find("[data-handle=reset]");
        var $remove = element.find("[data-handle=remove]");
        var $previews = element.find("[data-handle=previewArea]");
        // Options either global for all image type fields, or use 'data-*' elements for options passed in via the CRUD controller
        var options = {
            viewMode: 2,
            checkOrientation: false,
            autoCropArea: 1,
            responsive: true,
            preview : element.find('.img-preview'),
            aspectRatio : element.attr('data-aspectRatio')
        };
        var crop = element.attr('data-crop');

        // Hide 'Remove' button if there is no image saved
        if (!$hiddenImage.val()){
            $previews.hide();
            $remove.hide();
        }
        // Make the main image show the image in the hidden input
        $mainImage.attr('src', $hiddenImage.val());

        // Only initialize cropper plugin if crop is set to true
        if(crop){

            $remove.click(function() {
                $mainImage.cropper("destroy");
                $mainImage.attr('src','');
                $hiddenImage.val('');
                if (filename == "true"){
                    $hiddenFilename.val('removed');
                }
                $rotateLeft.hide();
                $rotateRight.hide();
                $zoomIn.hide();
                $zoomOut.hide();
                $reset.hide();
                $remove.hide();
                $previews.hide();
            });
        } else {

            $remove.click(function() {
                $mainImage.attr('src','');
                $hiddenImage.val('');
                $hiddenFilename.val('removed');
                $remove.hide();
                $previews.hide();
            });
        }

        //Set hiddenFilename field to 'removed' if image has been removed.
        //Otherwise hiddenFilename will be null if no changes have been made.

        $uploadImage.change(function() {
            var fileReader = new FileReader(),
                    files = this.files,
                    file;

            if (!files.length) {
                return;
            }
            file = files[0];

            if (/^image\/\w+$/.test(file.type)) {
                $hiddenFilename.val(file.name);
                fileReader.readAsDataURL(file);
                fileReader.onload = function () {
                    $uploadImage.val("");
                    $previews.show();
                    if(crop){
                        $mainImage.cropper(options).cropper("reset", true).cropper("replace", this.result);
                        // update the hidden input after selecting a new item or cropping
                        $mainImage.on('ready cropstart cropend', function() {
                            var imageURL = $mainImage.cropper('getCroppedCanvas').toDataURL(file.type);
                            $hiddenImage.val(imageURL);
                            return true;
                        });

                        $rotateLeft.show();
                        $rotateRight.show();
                        $zoomIn.show();
                        $zoomOut.show();
                        $reset.show();
                        $remove.show();

                    } else {
                        $mainImage.attr('src',this.result);
                        $hiddenImage.val(this.result);
                        $remove.show();
                    }
                };
            } else {
                new Noty({
                    type: "error",
                    text: "<strong>Please choose an image file</strong><br>The file you've chosen does not look like an image."
                }).show();
            }
        });

        //moved the click binds outside change event, or we would register as many click events for the same amout of times
        //we triggered the image change
        if(crop) {
            $rotateLeft.click(function() {
                $mainImage.cropper("rotate", 90);
                $mainImage.trigger('cropend');
            });

            $rotateRight.click(function() {
                $mainImage.cropper("rotate", -90);
                $mainImage.trigger('cropend');
            });

            $zoomIn.click(function() {
                $mainImage.cropper("zoom", 0.1);
                $mainImage.trigger('cropend');
            });

            $zoomOut.click(function() {
                $mainImage.cropper("zoom", -0.1);
                $mainImage.trigger('cropend');
            });

            $reset.click(function() {
                $mainImage.cropper("reset");
                $mainImage.trigger('cropend');
            });
        }

        element.on('CrudField:disable', function(e) {
            element.children('.btn-group').children('button[data-handle=remove]').attr('disabled','disabled');
            element.children('.btn-group').children('.btn-file').children('input[data-handle=uploadImage]').attr('disabled','disabled');

        });

        element.on('CrudField:enable', function(e) {
            element.children('.btn-group').children('.btn-file').children('input[data-handle=uploadImage]').removeAttr('disabled');
            element.children('.btn-group').children('button[data-handle=remove]').removeAttr('disabled');
        });
}

        