<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\ListingReviewsRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class ListingReviewsCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class ListingReviewsCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\ListingReviews::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/listing-reviews');
        CRUD::setEntityNameStrings('listing reviews', 'listing reviews');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
//        CRUD::column('listing_id')->label('Lawyer')->type('text')->name('listing_id')->entity('listings')->attribute('first_name')->model('App\Models\Listing');

        CRUD::column('listing_id')->type('select')->label('Listing title')
         ->entity('listings')
         ->attribute('title')
         ->model('App\Models\Listing');


        CRUD::column('user_id')->type('select')->label('Comment by')
         ->entity('user')
         ->attribute('name')
         ->model('App\Models\User');

        CRUD::column('comment')->label('Comment')->type('textarea');
        CRUD::column('rating')->label('Rating')->type('number');
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(ListingReviewsRequest::class);

        // DATA
        CRUD::field([
            'label'     => "Lawyer",
            'type'      => 'text',
            'name'      => 'listing_id',
            'entity'    => 'listings',
            'model'     => "App\Models\Listing",
            'attribute' => 'name',
        ]);

        CRUD::field([
            'label'     => "User",
            'type'      => 'text',
            'name'      => 'user_id',
            'entity'    => 'users',
            'model'     => "App\Models\User",
            'attribute' => 'name',
        ]);

        CRUD::field([
            'name' => 'rating',
            'type' => 'number',
            'label' => 'Rating',
        ]);

        CRUD::field([
            'name' => 'comment',
            'type' => 'textarea',
            'label' => 'Comment',
        ]);

        CRUD::field([ 
            'label'   => 'Approved',
            'type'    => 'select_from_array',
            'name'    => 'approved',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
