@include('header')
@include('functions')

<?php
use App\Models\BlogCategories;

$catdt = BlogCategories::where('id', $blog_data->category)->first();
$blog_url = url('/').'/edu/'.$catdt->slug.'/'.$blog_data->slug;
if($catdt->parent_id != ""){
	$catparentdt = BlogCategories::where('id', $catdt->parent_id)->first();
	$blog_url = url('/').'/edu/'.$catparentdt->slug.'/'.$catdt->slug.'/'.$blog_data->slug;
}

$faqs = array();
if(isset($blog_data->extras)){
	$extras = json_decode($blog_data->extras);	
	if(isset($extras->faqs) && !empty($extras->faqs)){
		$faqs = $extras->faqs;
	}
} ?>

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/toc.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/article-page.css">

<!-- article banner section start -->
<div class="article-banner-section">
	<div class="container w-1280">
		<div class="article-banner-wapper">
			<div class="main-article-banner-top-link">
				<ul>
					<li><a href="{{ url('/') }}/edu/" title="Home">Advisor</a></li>
					<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
					<li><a href="#">  Legal </a></li>
				</ul>
			</div>
			<div class="article-banner-title-text-wapper">
				<h1>{{ $blog_data->name }}</h1>
				<ul>
					<?php if ($blog_data->written){ ?>
						<li>
							<img src="{{ $blog_data->written->profile_picture != NULL ? $blog_data->written->profile_picture : url('/').'/img/d_user.png' }}" alt="">
							<span>Written by <a href="{{ url('/') }}/author/{{ $blog_data->written->slug }}">{{ $blog_data->written->name }}</a></span>
						</li>
					<?php } ?>

					<?php if ($blog_data->fact_check){ ?>
						<li>
							<img src="{{ $blog_data->fact_check->profile_picture != NULL ? $blog_data->fact_check->profile_picture : url('/').'/img/d_user.png' }}" alt="">
							<span>Fact Checked by <a href="{{ url('/') }}/author/{{ $blog_data->fact_check->slug }}">{{ $blog_data->fact_check->name }}</a></span>
						</li>
					<?php } ?>

					<li><img src="{{ url('/') }}/img/Calendar 1.png" alt="" style="width: auto;height: auto;max-width: none;min-width: auto;"><span>Last Updated <a>{{ date("M d,Y", strtotime($blog_data->updated_at)); }}</a></span></li>
				</ul>
			</div>
			<div class="article-banner-img-wapper">
				<a href="{{ $blog_url }}"><img src="{{ $blog_data->featured_image != NULL ? $blog_data->featured_image : url('/').'/img/d_user.png' }}" alt=""></a>
			</div>
		</div>
	</div>
</div>
<!-- article banner section end -->

<!-- What Causes T-Bone section start -->
<div class="what-causes-accidents-section">
	<div class="container w-1280">
		<div class="row">
			<div class="col-xl-4 col-lg-5 col-md-12 col-12">

				<?php if($blog_data->content != "" || !empty($faqs)){ ?>
					<div class="type-of-car-left-wapper right-sidebar-wapper" id="sidebar-Wrap1">
						<div class="side-bar-overflow1">
							<span class="sidebar-toc-heading">Table of content</span>
							<ul class="sidebar-text sidebar-ul"></ul>
						</div>
					</div>
				<?php } ?>

			</div>
			<div class="col-xl-8 col-lg-7 col-md-12 col-12">
				<div class="type-of-cars-right-wapper learn-about-wapper">

					<?php if ($blog_data->content != ""){ ?>
						<div class="type-of-cars-right-inner-text-wapper">
							<?php echo preg_replace('/ style=("|\')(.*?)("|\')/','',$blog_data->content); ?>
						</div>
					<?php } ?>

					<?php if(!empty($faqs)){ ?>
						<div class="type-of-cars-right">
							<h2>FAQ</h2>
							<div class="cp-review-faq-wapper">
								<div class="cp-faq-accordion-wapper">

									<?php foreach($faqs as $faq){ ?>
										<div class="cp-faq-accordion-item">
											<div class="d-flex align-items-baseline cp-faq-menu">
												<a href="javascript:void(0)"><?php echo $faq->faq_title; ?></a>
											</div>
											<div class="cp-faq-content">
												<?php echo preg_replace('/ style=("|\')(.*?)("|\')/','',$faq->faq_description); ?>
											</div>
										</div>
									<?php } ?>

								</div>
							</div>
						</div>
					<?php } ?>

				</div>
			</div>

			<?php if($blog_data->content != "" || !empty($faqs)){ ?>
				<!-- mobile view toc button start -->
				<div class="mobile-view-toc-wapper">
					<div class="right-sidebar-wapper" id="m-sidebar-Wrap1">
						<div class="side-bar-overflow1">
							<span class="sidebar-toc-heading">Table of content</span>
							<ul class="sidebar-text sidebar-ul"></ul>
						</div>
					</div>
					<button class="m-view-toc-btn">Menu</button>
				</div>
				<!-- mobile view toc button end -->
			<?php } ?>
		</div>
	</div>
</div>
<!-- What Causes T-Bone section end -->

<!-- Atricles written section end -->
<script src="{{ url('/') }}/js/toc.js"></script>
<script src="{{ url('/') }}/js/article-page.js"></script>

@include('footer')