@include('header')

<link rel="stylesheet" type="text/css" href="css/contact-page.css">

<script type="text/javascript">
    var widgetId1;
    var onloadCallback = function() {
        widgetId1 = grecaptcha.render('contact_captcha', {
            'sitekey' : '6LfKwT4pAAAAAONzPs_S4jUuY2yCpc6L_hjngFu_', 'theme' : 'light','size':"full"
        });
    };
</script>
<script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async defer></script>
<script>
    var contactURL = '/contact';
</script>
<script src='js/contact_page.js'></script>

<!-- Contact Frank section start -->
<div class="contact-Frank-section">
    <div class="container w-1280">
        <div class="contact-Frank-card-wapper">
            <?php if($page->extras['lawyer_image'] != ""){ ?>
                <div class="contact-Frank-card-img">
                    <img src="<?php echo $page->extras['lawyer_image']; ?>" alt="">
                </div>
            <?php } ?>
            <h2><?php echo $page->extras['form_upper_title']; ?></h2>
            <p><?php echo $page->extras['short_content']; ?></p>
        </div>
        <div class="contact-form-wapper">
            <form action="javascript:void(0)" id="contact_form">

                <?php $c_emails = $page->extras['c_email_ids'];
                if(!empty($c_emails)){ ?>
                    <div class="support-drop-down drop-down-open">
                        <div class="support-selected">
                            <a href="javascript:void(0)">
                                <span>Please Select</span>
                                <img src="img/arrow-f-icon.svg" alt="" class="arrow-f-icon">
                            </a>
                        </div>

                        <div class="support-options">
                            <ul>
                                <?php foreach($c_emails as $ce){ ?>
                                    <li>
                                        <a href="javascript:void(0)" value="<?php echo $ce['email_id']; ?>" class="selected-a"><?php echo $ce['email_title']; ?></a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                <?php } ?>
                
                <div class="form-group">
                    <input type="text" name="first_name" id="first_name" placeholder="First Name"
                    class="form-control">
                </div>
                <div class="form-group">
                    <input type="text" name="last_name" id="last_name" placeholder="Last Name" class="form-control">
                </div>
                <div class="form-group">
                    <input type="text" name="contact" id="contact" placeholder="Email or phone"
                    class="form-control">
                </div>
                <div class="form-group">
                    <input type="text" name="zip" id="zip" placeholder="ZIP" class="form-control" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');">
                </div>
                <div class="form-group">
                    <textarea rows="3" name="contact_summary" id="contact_summary" class="form-control"
                    placeholder="Tell us sbout your legal need"></textarea>
                </div>
                <div id="contact_captcha"></div>
                <div class="error mt-3 text-center"></div>
                <div class="Send-request-btn">
                    <a href="#" id="contact_submit"><img src="img/fi_10322481.png" alt="">Send request</a>
                </div>
                <p>DISCLAIMER: <?php echo $page->extras['form_desclaimer']; ?></p>
            </form>
        </div>
    </div>
</div>
<!-- Contact Frank section end -->

<!-- How Do I Choose section start -->
<div class="how-do-i-choose-section">
    <div class="container w-1280">
        <div class="row">
            <div class="col-xl-6 col-lg-6 col-md-12 col-12">
                <div class="how-do-i-choose-card-wapper">
                    <?php echo $page->extras['b_r_1_right']; ?>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6 col-md-12 col-12">
                <div class="how-do-i-choose-card-wapper">
                    <?php echo $page->extras['b_r_1_left']; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-6 col-lg-6 col-md-12 col-12">
                <div class="how-do-i-choose-card-wapper">
                    <?php echo $page->extras['b_r_2_right']; ?>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6 col-md-12 col-12">
                <div class="how-do-i-choose-card-wapper">
                    <?php echo $page->extras['b_r_2_left']; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- How Do I Choose section end -->

@include('footer')
