<?php
namespace App\Http\Controllers;

use Backpack\PageManager\app\Models\Page;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;
use App\Models\PracticeArea;
use App\Models\Listing;
use App\Models\listing_reviews;
use App\Models\Address;
use App\Models\User;
use Spatie\SchemaOrg\Schema;
use Illuminate\Support\Facades\Artisan;

class PageController extends Controller
{
     protected $data=[];
    public function index($slug = '/', $subs = null)
    {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);


        Artisan::call('cache:clear');
        Artisan::call('config:clear');

        $page = Page::findBySlug($slug);
        // return view('pages.home');


        if (!$page || $subs != "") {
            $full_url = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            $c_url = substr(url()->full(), strrpos(url()->full(), '/') + 1);
            $c_url = urldecode(str_replace("?", "/?", $c_url));

            $exist = DB::select('SELECT * FROM `custom_redirect` WHERE `url` = "'.$full_url.'"');
            // dd($exist);
            if(!empty($exist)){
                if (str_contains($c_url, 'contact-us')) {
                    return redirect(url("/contact"), 301);
                }else{
                    $red_url = str_replace("http:","https:",url("/"));
                    $red_url = str_replace("www.","",$red_url);
                    return redirect($red_url, 301);
                }
            }else{
                abort(404, 'Please go back to our <a href="' . url('') . '">homepage</a>.');
            }
        }

        // SEARCH PAGE
        if (isset($_REQUEST['search']) && $_REQUEST['search'] != "") {
            $search_q = $_REQUEST['search'];
            $page = Page::findBySlug('search');

            $this->data['title'] = $page->title;
            $this->data['page'] = $page->withFakes();
            $this->data['search_q'] = $search_q;

            // GET LAWYERS
            $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->with('jurisdiction')->whereHas('practiceAreas', function ($query) {
                $query->where('listing_practice_area.practice_area_id', '!=', '');
            })->whereHas('address', function ($query) {
                $query->where('state', '!=', '');
            })->Where('listings.first_name', 'like', '%' . $search_q)->orderby('featured', 'DESC')->paginate(6);
            $this->data['lawyers'] = $lawyers;

            return view('pages/search_result', $this->data)->withShortcodes();
        }

        // GET PRACTICE AREAS & STATES
        $p_areas = array();$list_parea = array();
        $all_states = array();$list_state = array();

        $practice_a = DB::select('SELECT * FROM `practice_areas` ORDER BY `name` ASC');
        $states = DB::select('SELECT * FROM `states` ORDER BY `name` ASC' );

        $listing_ids = DB::table('listing_practice_area')
         ->select('listing_practice_area.*','listing_address.*')
        ->join('listing_address', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
        ->get();

        // $listing_ids = DB::table('listing_practice_area')
        //  ->select('listing_practice_area.practice_area_id','listing_address.state')
        // ->join('listing_address', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
        // ->get();

        // $listing_ids = DB::table('listing_practice_area')
        // ->select(
        //     'listing_practice_area.*',
        //     'listing_address.label',
        //     'listing_address.full_address',
        //     'listing_address.county',
        //     'listing_address.city',
        //     'listing_address.state',
        //     'listing_address.country',
        //     'listing_address.zipcode'
        // )
        // ->join('listing_address', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
        // ->get();
    

     
        if(!empty($listing_ids)){
            foreach($listing_ids as $l_ids){
                array_push($list_parea, $l_ids->practice_area_id);
                array_push($list_state, trim($l_ids->state));
            }
        }

         $list_parea = array_filter(array_values(array_unique($list_parea)));
         $list_state = array_filter(array_values(array_unique($list_state)));
       
        if (!empty($practice_a) && !empty($list_parea)) {
            foreach ($practice_a as $p_a) {
                if(in_array($p_a->id, $list_parea)){
                    $p_areas[$p_a->id]['name'] = $p_a->name;
                    $p_areas[$p_a->id]['slug'] = $p_a->slug;
                }
            }
        }
        
        if (!empty($states) && !empty($list_state)) {
            foreach($states as $st){
                 if(in_array($st->name, $list_state)){
                    array_push($all_states, $st->name);
                 }
            }
        }

        // GET REVIEWS
        $reviews = DB::table('listing_reviews')->get();

        $this->data['title'] = $page->title;
        $this->data['page'] = $page->withFakes();
        $this->data['p_areas'] = $p_areas;
        $this->data['states'] = $all_states;
        $this->data['reviews'] = $reviews;
    
        Artisan::call('cache:clear');
        Artisan::call('config:clear');

        if (view()->exists('pages.' . $page->template)) {
             return view('pages.' . $page->template, $this->data)->withShortcodes();
            
        }else{
            abort(404, 'Please go back to our <a href="' . url('') . '">homepage</a>.');
        }
    }

    public function all_register(){
        $page = Page::findBySlug('register');

        $this->data['title'] = $page->title;
        $this->data['page'] = $page->withFakes();

        return view('pages/register', $this->data)->withShortcodes();
    }

    public function upgraded_to_premium_payment(){
        $page = Page::findBySlug('upgraded-to-premium-payment');

        $user_data = array();
        $old_data = array();

        if(Session::has('f_user_login')){
            if(Session::get('f_user_login') == 1){
                $user_data['user_id'] = Session::get('user_id');
                $user_data['username'] = Session::get('username');
            }
        }

        $this->data['title'] = $page->title;
        $this->data['page'] = $page->withFakes();
        $this->data['user'] = $user_data;
        $this->data['old_data'] = $old_data;

        return view('pages/upgraded_to_premium_payment', $this->data)->withShortcodes();
    }

    public function lawyer_register(){
        $page = Page::findBySlug('lawyer-register');

        // $pareas = DB::select('SELECT * FROM `practice_areas`');
        // foreach($pareas as $p_a){
        //     $str_1 = str_replace(" ", "-", strtolower($p_a->name));
        //     $str_2 = str_replace("&", "-", $str_1); 
        //     $str_3 = str_replace("/", "-", $str_2); 
        //     $str_4 = str_replace("--", "-", $str_3); 
        //     $str_5 = str_replace("--", "-", $str_4); 

        //     $PA_slug_update = DB::table('practice_areas')->where('id', $p_a->id)->update([ 'slug' => $str_5, ]);
        //     echo $str_5.'<br>';
        // }

        $this->data['title'] = $page->title;
        $this->data['page'] = $page->withFakes();

        return view('pages/lawyer_register', $this->data)->withShortcodes();
    }

    public function my_account(){
        $page = Page::findBySlug('my-account');
        $user_data = array();
        $ex_data = array();
        $old_data = array();
        $verified = "0";

        if(Session::has('f_user_login')){
            if(Session::get('f_user_login') == 1){
                $user_data['user_id'] = Session::get('user_id');
                $user_data['username'] = Session::get('username');

                $user = DB::table('users')->where('id', $user_data['user_id'])->first();
                $user_data['user_data'] = $user;

                $user_role = DB::table('model_has_roles')->where('model_id', $user_data['user_id'])->first();
                $user_role = DB::table('roles')->where('id', $user_role->role_id)->first();
                $user_data['user_role'] = $user_role->name;

                if($user_role->name == "Lawyer"){
                    $firms = DB::select('SELECT `id`,`name` FROM `firms`');
                    $p_areas = DB::select('SELECT `id`,`name` FROM `practice_areas`');
                    $fees = DB::select('SELECT `id`,`name` FROM `fees`');
                    $district = DB::select('SELECT `id`,`name` FROM `districts`');

                    $ex_data['firms'] = $firms;
                    $ex_data['p_areas'] = $p_areas;
                    $ex_data['fees'] = $fees;
                    $ex_data['district'] = $district;

                    $old_data['info'] = array();
                    $old_data['l_parea'] = array();
                    $old_data['fees'] = array();
                    $old_data['jurisdictions'] = array();
                    $old_data['address'] = array();
                    $old_data['pro_experience'] = array();
                    $old_data['edu_exp'] = array();
                    $old_data['pro_associates'] = array();
                    $old_data['publications'] = array();
                    $old_data['webs'] = array();
                    $old_data['social'] = array();

                    $verify_status = DB::table('user_verification_documents')->where('user_id', $user_data['user_id'])->first();
                    if(!empty($verify_status)){
                        if($verify_status->verified == "yes"){
                            $verified = "1";
                        }
                    }

                    $old_info = DB::table('listings')->where('user_id', $user_data['user_id'])->first();
                    if(!empty($old_info)){
                        $verified = $old_info->admin_verified;

                        $old_data['info'] = $old_info;

                        $l_parea = DB::select('SELECT `practice_area_id` FROM `listing_practice_area` WHERE `listing_id`="'.$old_info->id.'"');
                        if(!empty($l_parea)){
                            $l_pareas = array();
                            foreach ($l_parea as $pa) {
                                array_push($l_pareas, $pa->practice_area_id);
                            }
                        }
                        $old_data['l_parea'] = $l_pareas;

                        $fees = DB::select('SELECT * FROM `listing_fees` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['fees'] = $fees;

                        $jurisdictions = DB::select('SELECT * FROM `listing_jurisdictions` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['jurisdictions'] = $jurisdictions;

                        $address = DB::select('SELECT * FROM `listing_address` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['address'] = $address;

                        $pro_experience = DB::select('SELECT * FROM `listing_professional_experiences` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['pro_experience'] = $pro_experience;

                        $edu_exp = DB::select('SELECT * FROM `listing_educations` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['edu_exp'] = $edu_exp;

                        $pro_associates = DB::select('SELECT * FROM `listing_professional_associations` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['pro_associates'] = $pro_associates;

                        $publications = DB::select('SELECT * FROM `listing_publications` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['publications'] = $publications;

                        $webs = DB::select('SELECT * FROM `listing_links` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['webs'] = $webs;

                        $social = DB::select('SELECT * FROM `listing_social_networks` WHERE `listing_id`="'.$old_info->id.'"');
                        $old_data['social'] = $social;
                    }
                }
            }
        }

        $this->data['title'] = $page->title;
        $this->data['page'] = $page->withFakes();
        $this->data['user'] = $user_data;
        $this->data['ex_data'] = $ex_data;
        $this->data['old_data'] = $old_data;
        $this->data['verified'] = $verified;

        return view('pages/my_account', $this->data)->withShortcodes();
    }

    public function verify_account(){
        $page = Page::findBySlug('verify-account');

        $user_data['user_id'] = Session::get('user_id');
        $user_data['username'] = Session::get('username');

        $user = DB::table('users')->where('id', $user_data['user_id'])->first();

        if($user){
            $user_data['user_data'] = $user;

            $user_role = DB::table('model_has_roles')->where('model_id', $user_data['user_id'])->first();
            $user_role = DB::table('roles')->where('id', $user_role->role_id)->first();
            $user_data['user_role'] = $user_role->name;

            $this->data['title'] = $page->title;
            $this->data['page'] = $page->withFakes();
            $this->data['user'] = $user_data;
        }else{
            return redirect('/register');
        }

        return view('pages/verify_account', $this->data)->withShortcodes();
    }

    public function activate_account(Request $request) {
        $token = $request->email_verification_token;
        $user = User::where('email_verification_token', $token)->first();

        if ($user) {
            $user->email_verified_at = now();
            $user->email_verification_token = null; 
            $user->save();

            Session::put('f_user_login', 1);
            Session::put('user_id', $user->id);
            Session::put('username', $user->name);

            $page = Page::findBySlug('my-account');
            $user_data = array();
            $ex_data = array();
            $old_data = array();
            $verified = "0";

            $user_data['user_id'] = Session::get('user_id');
            $user_data['username'] = Session::get('username');

            $user = DB::table('users')->where('id', $user_data['user_id'])->first();
            $user_data['user_data'] = $user;

            $user_role = DB::table('model_has_roles')->where('model_id', $user_data['user_id'])->first();
            $user_role = DB::table('roles')->where('id', $user_role->role_id)->first();
            $user_data['user_role'] = $user_role->name;

            if($user_role->name == "Lawyer"){
                $firms = DB::select('SELECT `id`,`name` FROM `firms`');
                $p_areas = DB::select('SELECT `id`,`name` FROM `practice_areas`');
                $fees = DB::select('SELECT `id`,`name` FROM `fees`');
                $district = DB::select('SELECT `id`,`name` FROM `districts`');

                $ex_data['firms'] = $firms;
                $ex_data['p_areas'] = $p_areas;
                $ex_data['fees'] = $fees;
                $ex_data['district'] = $district;

                $old_data['info'] = array();
                $old_data['l_parea'] = array();
                $old_data['fees'] = array();
                $old_data['jurisdictions'] = array();
                $old_data['address'] = array();
                $old_data['pro_experience'] = array();
                $old_data['edu_exp'] = array();
                $old_data['pro_associates'] = array();
                $old_data['publications'] = array();
                $old_data['webs'] = array();

                $verify_status = DB::table('user_verification_documents')->where('user_id', $user_data['user_id'])->first();
                if(!empty($verify_status)){
                    if($verify_status->verified == "yes"){
                        $verified = "1";
                    }
                }

                $old_info = DB::table('listings')->where('user_id', $user_data['user_id'])->first();
                if(!empty($old_info)){
                    $verified = $old_info->admin_verified;

                    $old_data['info'] = $old_info;

                    $l_parea = DB::select('SELECT `practice_area_id` FROM `listing_practice_area` WHERE `listing_id`="'.$old_info->id.'"');
                    if(!empty($l_parea)){
                        $l_pareas = array();
                        foreach ($l_parea as $pa) {
                            array_push($l_pareas, $pa->practice_area_id);
                        }
                    }
                    $old_data['l_parea'] = $l_pareas;

                    $fees = DB::select('SELECT * FROM `listing_fees` WHERE `listing_id`="'.$old_info->id.'"');
                    $old_data['fees'] = $fees;

                    $jurisdictions = DB::select('SELECT * FROM `listing_jurisdictions` WHERE `listing_id`="'.$old_info->id.'"');
                    $old_data['jurisdictions'] = $jurisdictions;

                    $address = DB::select('SELECT * FROM `listing_address` WHERE `listing_id`="'.$old_info->id.'"');
                    $old_data['address'] = $address;

                    $pro_experience = DB::select('SELECT * FROM `listing_professional_experiences` WHERE `listing_id`="'.$old_info->id.'"');
                    $old_data['pro_experience'] = $pro_experience;

                    $edu_exp = DB::select('SELECT * FROM `listing_educations` WHERE `listing_id`="'.$old_info->id.'"');
                    $old_data['edu_exp'] = $edu_exp;

                    $pro_associates = DB::select('SELECT * FROM `listing_professional_associations` WHERE `listing_id`="'.$old_info->id.'"');
                    $old_data['pro_associates'] = $pro_associates;

                    $publications = DB::select('SELECT * FROM `listing_publications` WHERE `listing_id`="'.$old_info->id.'"');
                    $old_data['publications'] = $publications;

                    $webs = DB::select('SELECT * FROM `listing_links` WHERE `listing_id`="'.$old_info->id.'"');
                    $old_data['webs'] = $webs;
                }
            }

            $this->data['title'] = $page->title;
            $this->data['page'] = $page->withFakes();
            $this->data['user'] = $user_data;
            $this->data['ex_data'] = $ex_data;
            $this->data['old_data'] = $old_data;
            $this->data['verified'] = $verified;
            return view('pages/my_account', $this->data)->withShortcodes();

        } else {
            return redirect('/');
        }
    }

    // HEADER SEARCH
    public function header_search(Request $request){
        $search_q = $request->search_q;
        $page = Page::findBySlug('search');

        $this->data['title'] = $page->title;
        $this->data['page'] = $page->withFakes();
        $this->data['search_q'] = $search_q;

        // GET LAWYERS
        $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->with('jurisdiction')->whereHas('practiceAreas', function ($query){
            $query->where('listing_practice_area.practice_area_id', '!=', '');
        })->whereHas('address', function ($query){
            $query->where('state', '!=', '');
        })->Where('listings.first_name', 'like', '%' . $search_q)->orderby('featured','DESC')->paginate(6);
        $this->data['lawyers'] = $lawyers;

        return view('pages/search_result', $this->data)->withShortcodes();
    }

    // HEADER SEARCH PAGINATE
    // public function ic_lawyers_search_paginate(Request $request){
    //     $search_q = $request->q;

    //     // GET LAWYERS
    //     $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->with('jurisdiction')->whereHas('practiceAreas', function ($query){
    //         $query->where('listing_practice_area.practice_area_id', '!=', '');
    //     })->whereHas('address', function ($query){
    //         $query->where('state', '!=', '');
    //     })->Where('listings.first_name', 'like', '%' . $search_q)->orderby('featured','DESC')->paginate(6);

    //     $s_arr = array('search_q','lawyers');
    //     return view('lawyers/lawyers_pagination', compact($s_arr))->render()->withShortcodes();
    // }
}
