
<?php
    // if no iconset was provided, set the default iconset to Font-Awesome
    $field['iconset'] = $field['iconset'] ?? 'fontawesome';
?>

<?php echo $__env->make('crud::fields.inc.wrapper_start', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <label><?php echo $field['label']; ?></label>
    <?php echo $__env->make('crud::fields.inc.translatable_icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div>
        <button type="button" class="btn btn-light iconpicker btn-sm" role="icon-selector"></button>
        <input
            type="hidden"
            name="<?php echo e($field['name']); ?>"
            data-iconset="<?php echo e($field['iconset']); ?>"
            bp-field-main-input
            data-init-function="bpFieldInitIconPickerElement"
            value="<?php echo e(old_empty_or_null($field['name'], '') ??  $field['value'] ?? $field['default'] ?? ''); ?>"
            <?php echo $__env->make('crud::fields.inc.attributes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        >
    </div>

    
    <?php if(isset($field['hint'])): ?>
        <p class="help-block"><?php echo $field['hint']; ?></p>
    <?php endif; ?>
<?php echo $__env->make('crud::fields.inc.wrapper_end', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>





    
    <?php switch($field['iconset']):
        case ('ionicon'): ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/ionicons-1.5.2/css/ionicons.min.css'); ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/ionicons-1.5.2/fonts/ionicons.woff'); ?>
            <?php break; ?>
        <?php case ('weathericon'): ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/weather-icons-1.2.0/css/weather-icons.min.css'); ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/weather-icons-1.2.0/fonts/weathericons-regular-webfont.woff'); ?>
            <?php break; ?>
        <?php case ('mapicon'): ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/map-icons-2.1.0/css/map-icons.min.css'); ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/map-icons-2.1.0/fonts/map-icons.woff'); ?>
            <?php break; ?>
        <?php case ('octicon'): ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/octicons-2.1.2/css/octicons.min.css'); ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/octicons-2.1.2/fonts/octicons.woff'); ?>
            <?php break; ?>
        <?php case ('typicon'): ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/typicons-2.0.6/css/typicons.min.css'); ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/typicons-2.0.6/fonts/typicons.woff'); ?>
            <?php break; ?>
        <?php case ('elusiveicon'): ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/elusive-icons-2.0.0/css/elusive-icons.min.css'); ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/elusive-icons-2.0.0/fonts/Elusive-Icons.woff'); ?>
            <?php break; ?>
        <?php case ('meterialdesign'): ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/material-design-1.1.1/css/material-design-iconic-font.min.css'); ?>
            <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker@1.8.2/icon-fonts/material-design-1.1.1/fonts/Material-Design-Iconic-Font.woff'); ?>
            <?php break; ?>
    <?php endswitch; ?>

    
    <?php $__env->startPush('crud_fields_styles'); ?>
        
        <?php Basset::basset('https://unpkg.com/bootstrap-iconpicker-latest@1.12.0/dist/css/bootstrap-iconpicker.min.css'); ?>
        
        
        <?php Basset::basset('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css'); ?>
        <?php Basset::basset('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/webfonts/fa-solid-900.woff2', false); ?>
        <?php Basset::basset('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/webfonts/fa-brands-400.woff2', false); ?>
        <?php Basset::basset('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/webfonts/fa-regular-400.woff2', false); ?>

        <style>
            button.btn-icon-selected>i.empty, button.iconpicker>i.empty {
                padding: 0px;
            }
            .iconpicker {
                display: block;
            }
            /* the default z-index from icon picker package is 1050 */
            /* we increment it here so that it's higher than our modals */
            .iconpicker-popover {
                z-index: 1055 !important;
            }
        </style>
    <?php $__env->stopPush(); ?>

    
    <?php $__env->startPush('crud_fields_scripts'); ?>
        
        <?php Basset::basset(base_path('vendor/backpack/pro/resources/assets/js/icon-picker.js')); ?>

        
        <?php $bassetBlock = 'backpack/pro/fields/icon-picker-field.js'; ob_start(); ?>
        <script>
            function bpFieldInitIconPickerElement(element) {
                var $iconset = element.attr('data-iconset');
                var $iconButton = element.siblings('button[role=icon-selector]');
                var $icon = element.attr('value');

                // we explicit init the iconpicker on the button element.
                // this way we can init the iconpicker in InlineCreate as in future provide aditional configurations.
                    $($iconButton).iconpicker({
                        iconset: $iconset,
                        icon: $icon
                    });

                    element.siblings('button[role=icon-selector]').on('change', function(e) {
                        $(this).siblings('input[type=hidden]').val(e.icon).trigger('change');
                    });

                    element.on('CrudField:enable', function(e) {
                        $iconButton.removeAttr('disabled');
                    });

                    element.on('CrudField:disable', function(e) {
                        $iconButton.attr('disabled', 'disabled');
                    });
            }
        </script>
        <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>
    <?php $__env->stopPush(); ?>
<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/vendor/backpack/pro/fields/icon_picker.blade.php ENDPATH**/ ?>