<?php

namespace App\Models;

use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PracticeArea extends Model
{
    use CrudTrait;
    use HasFactory;

    /*
    |--------------------------------------------------------------------------
    | GLOBAL VARIABLES
    |--------------------------------------------------------------------------
    */

    protected $table = 'practice_areas';
    // protected $primaryKey = 'id';
    // public $timestamps = false;
    protected $guarded = ['id'];
    // protected $fillable = [];
    // protected $hidden = [];
    protected $identifiableAttribute = 'name';
    /*
    |--------------------------------------------------------------------------
    | FUNCTIONS
    |--------------------------------------------------------------------------
    */

    public function getfrontlink()
    {
        $pa = $this->slug;
        return '<a href="' . url('lawyers/pa/'.$pa) . '" target="_blank">View</a>';
    }

    /*
    |--------------------------------------------------------------------------
    | RELATIONS
    |--------------------------------------------------------------------------
    */
    public function listings()
    {
        return $this->belongsToMany('App\Models\Listing', 'listing_practice_area');
    }

    public function faqs()
    {
        return $this->hasMany(\App\Models\PracticeAreaFaq::class);
    }

    public function practice_area()
    {
        return $this->belongsTo('App\Models\PracticeArea', 'parent_id');
    }
    public function parent()
    {
        return $this->belongsTo('App\Models\PracticeArea', 'parent_id');
    }
    /**
    * Get the child practice areas.
    */
    public function children()
    {
        return $this->hasMany('App\Models\PracticeArea', 'parent_id');
    }


    /*
    |--------------------------------------------------------------------------
    | SCOPES
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | ACCESSORS
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | MUTATORS
    |--------------------------------------------------------------------------
    */
}
