<?php
namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use App\Models\PracticeArea;
use App\Models\Listing;
use App\Models\listing_reviews;
use App\Models\Address;
use App\Models\Glossary;
use Illuminate\Support\Facades\Artisan;

class SearchController extends Controller
{
    // Top Search Filter
    public function top_search(Request $request)
    {
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
        $data = "";

        if ($request->type == "p_area") {
            // GET PRACTICE AREAS
            $p_areas = array();
            $all_pareas = array();

            // GET ALL PRACTICE AREAS
            $all_pa = DB::select('SELECT * FROM `practice_areas`');
            if (!empty($all_pa)) {
                foreach ($all_pa as $p_pa) {
                    $all_pareas[$p_pa->id]['name'] = $p_pa->name;
                    $all_pareas[$p_pa->id]['slug'] = $p_pa->slug;
                    $all_pareas[$p_pa->id]['parent_id'] = $p_pa->parent_id;
                }
            }

            // GET LISTING PRACTICE AREAS
            if ($request->city != "") {
                $pareas = DB::select('select * from `listing_practice_area` inner join `listing_address` on
                    `listing_address`.`listing_id` = `listing_practice_area`.`listing_id` 
                    where `listing_address`.`city` LIKE "' . $request->city . '%"');
  
            } else {
                $pareas = DB::select('select * from `listing_practice_area` inner join `listing_address` on
                    `listing_address`.`listing_id` = `listing_practice_area`.`listing_id`');
            }
            if (!empty($pareas)) {
                $i = 0;
                foreach ($pareas as $p_a) {
                    if (isset($all_pareas[$p_a->practice_area_id])) {
                        $p_data = $all_pareas[$p_a->practice_area_id];

                        if (!empty($p_data)) {
                            if (strpos(strtolower($p_data['name']), strtolower($request['q'])) === 0) {
                                if (isset($p_data['parent_id']) && $p_data['parent_id'] != "") {

                                    if (isset($all_pareas[$p_data['parent_id']])) {

                                        $p_parent_data = $all_pareas[$p_data['parent_id']];

                                        if (isset($p_parent_data)) {
                                            $p_areas[$i]['parent'] = $p_parent_data['name'];
                                            $p_areas[$i]['sub'] = $p_data['name'];
                                        } else {
                                            $p_areas[$i]['parent'] = $p_data['name'];
                                        }

                                        $p_areas[$i]['slug'] = $p_data['slug'];
                                    }
                                } else {
                                    $p_areas[$i]['parent'] = $p_data['name'];
                                    $p_areas[$i]['slug'] = $p_data['slug'];
                                }
                                $i++;
                            }
                        }
                    }
                }
            }
            $p_areas = array_map("unserialize", array_unique(array_map("serialize", $p_areas)));

            if (!empty($p_areas)) {
                foreach ($p_areas as $pa) {
                    if (isset($pa['sub'])) {
                        $data .= '<span tf_p_area="' . $pa['slug'] . '">' . $pa['sub'] . ' <s>(' . $pa['parent'] . ')</s></span>';
                    } else {
                        $data .= '<span tf_p_area="' . $pa['slug'] . '">' . $pa['parent'] . '</span>';
                    }
                }
            } else {
                $data .= '<p class="n_data">No Data Found</p>';
            }
        }

        if ($request->type == "s_c") {
            // GET STATES | CITY
            $res = array();
            $parea_l_ids = array();
            $dis_city = array();
            $add_cities = array();
            $q = strtolower($request->q);

            // GET LISTING PRACTICE AREAS
            $all_add_pareas = DB::select('SELECT DISTINCT `listing_id` FROM `listing_practice_area`');

            if (!empty($all_add_pareas)) {
                foreach ($all_add_pareas as $aparea) {
                    if (!in_array($aparea->listing_id, $parea_l_ids)) {
                        array_push($parea_l_ids, $aparea->listing_id);
                    }
                }
            }

            // GET LISTING STATES/CITIES
            $all_add_cities = DB::select('SELECT * FROM `listing_address`');

            if (!empty($all_add_cities)) {
                foreach ($all_add_cities as $acity) {
                    if (in_array($acity->listing_id, $parea_l_ids) && !in_array($acity->city, $add_cities)) {
                        array_push($add_cities, $acity->city);
                    }
                }
            }

            // GET STATES
            $state = DB::table('listing_address')
            ->select('*')
            ->join('listing_practice_area', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
            ->get();

            if ($request->p_area != "") {
                $p_area_data = DB::select('SELECT * FROM `practice_areas` WHERE `slug` = "' . $request->p_area . '"');
                if (isset($p_area_data[0])) {
                    $state = DB::table('listing_address')
                    ->select('*')
                    ->join('listing_practice_area', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
                    ->where('listing_practice_area.practice_area_id', $p_area_data[0]->id)
                    ->get();
                }
            }

            // GET SEARCH RESULT
            if ($state->count() > 0) {
                foreach ($state as $sc) {
                    if (!in_array($sc->city, $dis_city)) {
                        if (strpos(strtolower($sc->city), strtolower($q)) === 0 || strpos(strtolower($sc->state), strtolower($q)) === 0) {
                            if (in_array($sc->city, $add_cities)) {
                                $res[$sc->id]['tf_state'] = strtolower(str_replace(' ', '-', $sc->state));
                                $res[$sc->id]['tf_city'] = strtolower(str_replace(' ', '-', $sc->city));
                                $res[$sc->id]['state'] = $sc->state;
                                $res[$sc->id]['city'] = $sc->city;

                                array_push($dis_city, $sc->city);
                            }
                        }
                    }
                }
            }

            if (!empty($res)) {
                foreach ($res as $re) {
                    $data .= '<span tf_state="' . $re['tf_state'] . '" tf_city="' . $re['tf_city'] . '">' . $re['city'] . ', ' . $re['state'] . '</span>';
                }
            } else {
                $data .= '<p class="n_data">No Data Found</p>';
            }
        }
    
        return json_encode(array('success' => 'true', 'data' => $data));
    }

    // Header Search
    public function header_search(Request $request)
    {
        $search_q = $request->q;
        $ky = $request->ky;
        $type = $request->type;
        $data = "";

        // GET LAWYERS
        if ($ky == "All" || $ky == "Lawyers") {
            $l_count = 0;

            $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->with('jurisdiction')
            ->where(function ($query) use ($search_q) {
                $query->where('listings.first_name', 'like', '%' . $search_q.'%')
                ->orWhere('listings.middle_name', 'like', '%' . $search_q.'%');
            })->orderBy('listings.first_name', 'ASC')->get();

            if ($lawyers->count() > 0) {
                foreach ($lawyers as $lawyer) {
                    $name = ($lawyer->prefix ? $lawyer->prefix . '.' : '') . ' ' . $lawyer->first_name . ' ' . ($lawyer->middle_name ? $lawyer->middle_name : '') . ' ' . $lawyer->last_name;
                    $f_name = $lawyer->first_name;
                    $m_name = ($lawyer->middle_name ? $lawyer->middle_name : '');
                    $l_name = $lawyer->last_name;

                    if(str_starts_with(strtolower($f_name), strtolower($search_q)) || str_starts_with(strtolower($m_name), strtolower($search_q)) || str_starts_with(strtolower($l_name), strtolower($search_q))){
                        $url_name = strtolower($lawyer->first_name . '-' . ($lawyer->middle_name ? $lawyer->middle_name . '-' : '') . $lawyer->last_name);
                        $url_name = str_replace('.', '-', $url_name);
                        $url_name = str_replace(',', '-', $url_name);
                        $url_name = str_replace('`', '-', $url_name);
                        $url_name = str_replace("'", '-', $url_name);
                        $url_name = str_replace("(", '', $url_name);
                        $url_name = str_replace(")", '', $url_name);
                        $url_name = str_replace('--', '-', $url_name);
                        $url = url('/') . '/lawyer/' . str_replace(' ', '-', $url_name) . '-' . $lawyer->id;

                        $data .= '<span class="search_lawyer_result"><a href=' . $url . '>' . $name . ' </a>';

                        if ($type == "") {
                            $data .= '<s>in Lawyers</s></span>';
                        } else {
                            $data .= '</span>';
                        }

                        $l_count++;
                    }
                }

                if($l_count == 0){
                    $data .= '<p class="n_data search_lawyer_result">No Data Found <s>in Lawyers</s></p>';
                }
            } else {
                $data .= '<p class="n_data search_lawyer_result">No Data Found <s>in Lawyers</s></p>';
            }
        }

        // GET GLOSSARY
        if ($ky == "All" || $ky == "Glossary") {
            if ($type == "") {
                $glossaries = Glossary::all()->groupBy(function ($item) {
                    return Str::upper(substr($item->name, 0, 1));
                });

                $glossaries = $glossaries->map(function ($group) {
                    return $group->sortBy('name');
                });

                $glossaries = $glossaries->sortKeys();
                $g_i = 0;
                if (!empty($glossaries)) {
                    foreach ($glossaries as $letter => $entries) {
                        foreach ($entries as $entry) {
                            if (strpos($entry->name, $search_q) !== false) {
                                $url = url('/') . '/glossary-of-legal-terms#' . str_replace(" ", "-", $entry->name);
                                $data .= '<span class="search_glossary_result"><a href="' . $url . '">' . $entry->name . ' </a><s>in Glossary</s></span>';
                                $g_i++;
                            }
                        }
                    }
                } else {
                    $data .= '<p class="n_data search_glossary_result">No Data Found <s>in Glossary</s></p>';
                }

                if ($g_i == 0) {
                    $data .= '<p class="n_data search_glossary_result">No Data Found <s>in Glossary</s></p>';
                }
            }
        }

        return json_encode(array('success' => 'true', 'data' => $data));
    }
}