<?php

namespace App\Console\Commands;

use Carbon\Carbon;

use Illuminate\Console\Command;

use Illuminate\Support\Facades\Storage;

class DatabaseBackup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'db:backup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Automating Daily Backups';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        
    	if (!Storage::exists('backups/Laravel')) {
            Storage::makeDirectory('backups/Laravel');
        }
    	// if (!Storage::exists('backup')) {
     //        Storage::makeDirectory('backup');
     //    }

       // Generate backup filename
        $timestamp = Carbon::now()->format('Y-m-d_His');
        $sqlFilename = "backup-" . $timestamp . ".sql";
        $zipFilename = "backup-" . $timestamp . ".zip";

        // Paths
        $sqlPath = storage_path('app/backups/Laravel/' . $sqlFilename);
        $zipPath = storage_path('app/backups/Laravel/' . $zipFilename);

        // Perform database backup
        exec('/opt/bitnami/mariadb/bin/mariadb-dump --user=root --password=T4aCu0OEUiO, --host=127.0.0.1 legal_staging > ' . $sqlPath, $output, $exitCode);

        // Check if the SQL dump was successful
        if ($exitCode === 0) {
            // Create ZIP archive
            $zip = new \ZipArchive();
            if ($zip->open($zipPath, \ZipArchive::CREATE) === true) {
                $zip->addFile($sqlPath, basename($sqlPath));
                $zip->close();

                unlink($sqlPath);

                $this->info('Database backup created successfully: ' . $zipFilename);
            } else {
                $this->error('Failed to create ZIP archive.');
            }
        } else {
            $this->error('Database backup failed: ' . implode(PHP_EOL, $output));
        }
    }
}
