$(document).ready(function(){
	// SHOW SUCCESS OR ERROR TOAST
	function show_snak(class_nm, mssg) {
		jQuery("#snackbar").addClass(class_nm);
		jQuery("#snackbar").addClass("show");
		jQuery("#snackbar").html(mssg);

		setTimeout(function () { jQuery("#snackbar").removeClass("show"); jQuery("#snackbar").removeClass(class_nm); }, 3000);
	}

	// ON FILE CHOOSE CLICK
	$("#open_upload_btn").click(function(e) {
		e.preventDefault();
		$('#document_upload_model').modal('show');
	});

	// ON CHECKBOX CHANGE
	$(".v_file_select").fadeOut();
	$("#document_upload_model input[type='checkbox']").change(function(e) {
		if($(this).is(':checked')) {
			$(this).parent().parent().find(".v_file_select").fadeIn();
		} else {
			$(this).parent().parent().find(".v_file_select input").val("");
			$(this).parent().parent().find(".v_file_select").fadeOut();
		}
	});

	// ON UPLOAD CLICK
	var formData = new FormData();
	$("#doc_upload").click(function(e) {
		e.preventDefault();

		var fileExtension = ['jpeg', 'jpg', 'png', 'gif', 'bmp', 'pdf'];
		const chked = [];const err = [];const size_err = [];const ext_err = []; var inp_i = 0;
		$.each($("#document_upload_model input[type='checkbox']"), function () {
			if($(this).is(':checked')) {
				var file = $(this).parent().parent().find(".v_file_select input")[0].files[0];
				var name = file.name;
				chked.push("chk_"+inp_i);

				if(file == undefined || file == ""){
					err.push("err_"+inp_i);
				}else if(file.size > 11000000){
					size_err.push("err_"+inp_i);
				}else if ($.inArray(name.split('.').pop().toLowerCase(), fileExtension) == -1) {
					ext_err.push("err_"+inp_i);
				}else{
					var id = $(this).parent().parent().find(".v_file_select input").attr("id");
					formData.append(id, file);
				}
			}else{
				var id = $(this).parent().parent().find(".v_file_select input").attr("id");
				if(formData.has(id)){
					formData.delete(id);
				}
			}
			inp_i++;
		});

		if (chked.length == 0 || err.length >= 1) {
			show_snak("err", "Please Select Files");
		}else if(size_err.length >= 1){
			show_snak("err", "Please Select Files < 10MB");
		}else if(ext_err.length >= 1){
			show_snak("err","Only this formats are allowed : "+fileExtension.join(', '));
		}else{
			$(".req-docs .file_name").hide();
			$('#document_upload_model').modal('hide');
			$(".uploaded_files .file_name").html('');
			$(".uploaded_files .file_name").hide();

			for (const key of formData.keys()) {
				var ky = $("#"+key).parent().parent().find("label").text();
				$(".uploaded_files .file_name."+key).html('<b>'+ky+'</b> :- '+formData.get(key).name);
				$(".uploaded_files .file_name."+key).show();

				$(".req-docs li."+key+" img").css({"background":"var(--main_bg_1)"});
			}
		}
	});

	// ON VERIFY CLICK
	$("#verify_submit").click(function (e) {
		e.preventDefault();

		const files = [];
		$.each($(".doc_upload_form input[type='file']"), function () {
			var file = $(this)[0].files[0];

			if(file != undefined && file != ""){
				var name = file.name;
				files.push(name);
			}
		});

		if(files.length == 0){
			show_snak("err", "Please Select Files");
		}else{
			formData.append("c_user_id",$("#cur_u_id").val());

			jQuery(".floading").css("display", "unset");
			ajaxSend(formData, doc_ajax);
		}
	});

	function ajaxSend(data, url) {
		$.ajaxSetup({
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		});

		$.ajax({
			url: url,
			type: "POST",
			data: data,
			processData: false,
			contentType: false,
			dataType: 'json',
			success: function (response) {
				jQuery(".floading").css("display", "none");

				if (response.error == "") {
					show_snak("success", response.success);
				} else {
					show_snak("err", response.error);
				}
			},
		});
	}
});