$(document).ready(function(){
	// DATA TOGGLE
	$(".browse-states a").each(function(){
		var str1 = $(this).text();
		var str2 = "...";
		if(str1.indexOf(str2) != -1){
			$(this).attr("data-toggle","tooltip");
			$(this).attr("data-placement","top");
		}else{
			$(this).removeAttr("title");
		}
	});

	$('[data-toggle="tooltip"]').tooltip();
	
	/* menu js start*/
	$("#h-toggle-btn, .m-overlay-bg").click(function(e) {
		e.preventDefault();
		$("#wrapper").toggleClass("toggled");
		$(".h-toggle-btn").toggleClass("open");
		$("#h-sidebar-wrapper").toggleClass("h-menu-active");
		$(".m-overlay-bg").toggleClass('h-bg-active');
		$('body').toggleClass('open-nav');
	});
	/* menu js end*/

	if($('.search-btn').length) {
		$('.search-btn').on('click', function() {
			$('.h-home-wapper').addClass('moblie-search-active');
			$("#h_search_type").val("");
			$(".ts-header-card").removeClass("d-none");
			$('.search-popup .form-group input[type="search"]').val("").keyup();
		});
		$('.close-search, .search-back-drop').on('click', function() {
			$('.h-home-wapper').removeClass('moblie-search-active');
		});
	}

	// Content page js
	$(".type-of-car-card-title").click(function(){
		$(this).parent(".type-of-car-card-wapper").find(".type-of-car-card-inner").slideToggle();
	});

	// Sing up & login form modal popup
	$('.modal-form-a').click(function(){
		var modal_id = $(this).attr('data-target');
		$('.modal-show-wapper').modal('hide');
		$(modal_id).modal('show');
	});

	/* -------------------
	HEADER SEARCH
	-----------------------*/

	function header_search_send(q,h_search,ky,type){
		if(q.length >= 1){
			jQuery(".search-popup .p_search_results").css({"display":"block"});
			jQuery(".search-popup .p_search_results .ts-body-card span").remove();
			jQuery(".search-popup .p_search_results .ts-body-card .n_data").remove();
			jQuery(".search-popup input").addClass("header-results-open");

			const formData = new FormData();
			formData.append("q", q);
			formData.append("ky", ky);
			formData.append("type", type);

			jQuery(".p_search_loader").css({"display":"block"});

			if(type == "claim"){
				$(".ts-header-card").addClass("d-none");
			}

			$.ajax({
				url: h_search,
				type: "POST",
				data: formData,
				processData: false,
				contentType: false,
				async: false,
				dataType: "json",
				success: function (response) {
					jQuery(".search-popup .p_search_results .ts-body-card span").remove();
					jQuery(".search-popup .p_search_results .ts-body-card .n_data").remove();

					jQuery(".search-popup .p_search_results .ts-body-card").append(response.data);
					jQuery(".p_search_loader").css({"display":"none"});
				},
			});
		}else{
			jQuery(".search-popup .p_search_results").css({"display":"none"});
			jQuery(".search-popup .p_search_results .ts-body-card span").remove();
			jQuery(".search-popup .p_search_results .ts-body-card .n_data").remove();
			jQuery(".search-popup input").removeClass("header-results-open");
		}
	}

	// ON SEARCH FIELD INPUT
	jQuery(".search-popup input").on("keyup", function(e) {
		var q = jQuery(this).val();
		var type = jQuery("#h_search_type").val();
		var ky = "All";
		header_search_send(q,h_search,ky,type);
	});

	// ON TAB SELECT CHANGE
	jQuery(".search-popup .ts-search--header").on("click", function(e) {
		var q = jQuery(".search-popup input").val();
		var ky = jQuery(this).text();

		jQuery(".search-popup .ts-search--header").removeClass("ts-search--header-active");
		jQuery(this).addClass("ts-search--header-active");

		header_search_send(q,h_search,ky,'');
	});

	/* -------------------
	LOGIN FORM SUBMISSION
	-----------------------*/

	// HIDE ERRORS ON LOAD
	jQuery(".err").text("");
	jQuery(".err").fadeOut();
	jQuery("#login-form-modal .form_res").fadeOut();
	jQuery("#login-form-modal .form_res #form_loading").fadeOut();
	jQuery("#login-form-modal .form_res #l_form_message").fadeOut();

	function errorFadeIn(text,ele) {
		jQuery(ele).parent().find(".err").fadeIn();
		jQuery(".err").css("color", "#b70c0c");
		jQuery(ele).parent().find(".err").html(text);
		setTimeout(() => {
			jQuery(".err").fadeOut();
		}, 5000);
		return false;
	}

	function errorFadeOut() {
		jQuery(".err").fadeOut();
		jQuery(".err").css("color", "#fff");
		jQuery(".err").text("");
	}

	// CHECK IS EMAIL
	function isEmail(email) {
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		return regex.test(email);
	}

	// SHOW HIDE PASSWORD
	jQuery('#hl_view_p').click(function(){
		if('password' == jQuery('#hl_password').attr('type')){
			jQuery('#hl_password').prop('type', 'text');
		}else{
			jQuery('#hl_password').prop('type', 'password');
		}
	});

	// FORM SUBMISSION
	$("#h_login_submit").click(function (e) {
		e.preventDefault();
		$("#h_login_form").submit();
	});

	$("#h_login_form").submit(function (e) {
		e.preventDefault();
		var email = $("#hl_email").val();
		var password = $("#hl_password").val();

		if (email.length == 0) {
			errorFadeIn("Please double-check your email","#hl_email");
		}else if(!isEmail(email)){
			errorFadeIn("Please double-check your email","#hl_email");
		}else if (password.length == 0) {
			errorFadeIn("Login failed. Please double-check your password.","#hl_password");
		}else {
			errorFadeOut(".error");
			jQuery("#login-form-modal .form_res").fadeIn();
			jQuery("#login-form-modal .form_res #form_loading").fadeIn();

			$("#h_login_form").css("opacity", "0.8");
			const formData = new FormData();
			formData.append("email", $("#hl_email").val());
			formData.append("password", $("#hl_password").val());
			ajaxSend(formData, login);
		}
	});

	function ajaxSend(data, url) {
		$.ajaxSetup({
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		});
		$("#h_login_submit").attr("disabled", true);
		$.ajax({
			url: url,
			type: "POST",
			data: data,
			processData: false,
			contentType: false,
			success: function (response) {
				var response = JSON.parse(response);

				jQuery("#login-form-modal .form_res #form_loading").fadeOut();

				if(response.error == ""){
					jQuery("#login-form-modal .form_res #l_form_message").text(response.message);
					jQuery("#login-form-modal .form_res #l_form_message").fadeIn();

					setTimeout(function(){ 
						window.location.href = login.replace("login","")+"my-account";
					}, 1000);
				}else{
					$("#h_login_submit").attr("disabled", false);
					jQuery("#h_login_form").css("opacity", "1");
					jQuery("#login-form-modal .form_res").fadeOut();

					if(response.e_code == "e"){
						errorFadeIn(response.error,"#hl_email");
					}
					if(response.e_code == "p"){
						errorFadeIn(response.error,"#hl_password");
					}
				}
			},
		});
	}

	// RESEND VERIFICATION EMAIL
	jQuery("body").on("click change", "#resend_verification", function (e) {
		e.preventDefault();

		$.ajaxSetup({
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		});
		const formData = new FormData();
		formData.append("email", $("#hl_email").val());

		$.ajax({
			url: r_verify,
			type: "POST",
			data: formData,
			processData: false,
			contentType: false,
			success: function (response) {
				var response = JSON.parse(response);

				jQuery("#login-form-modal .form_res #form_loading").fadeOut();

				if(response.error == ""){
					errorFadeIn(response.message,"#hl_email");
				}else{
					$("#h_login_submit").attr("disabled", false);
					jQuery("#h_login_form").css("opacity", "1");
					jQuery("#login-form-modal .form_res").fadeOut();

					if(response.e_code == "e"){
						errorFadeIn(response.error,"#hl_email");
					}
				}
			},
		});
	});
});	