<?php use App\Models\BlogCategories; ?>

<div class="personal-injury-row-wapper">

	<?php foreach($blogs as $blog){
		$catdt = BlogCategories::where('id', $blog->category)->first();
		$blog_url = url('/').'/edu/'.$catdt->slug.'/'.$blog->slug;
		if($catdt->parent_id != ""){
			$catparentdt = BlogCategories::where('id', $catdt->parent_id)->first();
			$blog_url = url('/').'/edu/'.$catparentdt->slug.'/'.$catdt->slug.'/'.$blog->slug;
		} ?>

		<div class="personal-injury-card-wapper">
			<div class="personal-injury-card-img">
				<a href="{{ $blog_url }}">
					<img src="{{ $blog->featured_image != NULL ? $blog->featured_image : url('/').'/img/placeholder_image.svg' }}" alt="">
				</a>
			</div>
			<div class="personal-injury-card-inner">
				<span>{{ $catdt->name }}</span>

				<div class="personal-injury-card-inner-text">
					
					<?php if ($blog->written){ ?>
						<h6>Written by <a href="{{ url('/') }}/author/{{ $blog->written->slug }}">{{ $blog->written->name }}</a></h6>
					<?php } ?>

					<h3><a href="{{ $blog_url }}">{{ $blog->name }}</a></h3>
					<h5>UPDATED {{ date("M d,Y", strtotime($blog->updated_at)); }}</h5>
					<p><?php echo substr(strip_tags($blog->content),0,110) . "..."; ?></p>
					
				</div>
			</div>
		</div>
	<?php } ?>

</div>
<div class="personal-injury-Pagination-wapper blogs-pagination mt-5">
	{{ $blogs->links("pagination::bootstrap-5") }}
</div>