<?php

namespace App\Models;

use Backpack\CRUD\app\Models\Traits\HasIdentifiableAttribute;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\app\Models\Traits\SpatieTranslatable\Sluggable;
use Backpack\CRUD\app\Models\Traits\SpatieTranslatable\SluggableScopeHelpers;
use Backpack\CRUD\app\Models\Traits\SpatieTranslatable\HasTranslations;

use App\Models\PracticeArea;
use App\Models\State;
use App\Models\County;

class PracticeAreaStateCountyContent extends Model
{
    use CrudTrait;
    use HasFactory;

    /*
    |--------------------------------------------------------------------------
    | GLOBAL VARIABLES
    |--------------------------------------------------------------------------
    */

    protected $table = 'practice_area_state_county_content';
    // protected $primaryKey = 'id';
    // public $timestamps = false;
    protected $guarded = ['id'];
    protected $fillable = ['practiceArea', 'state', 'county', 'short_content', 'h2_after_s_c', 'full_content', 'metas', 'extras', 'url_index'];
    // protected $hidden = [];

    /*
    |--------------------------------------------------------------------------
    | FUNCTIONS
    |--------------------------------------------------------------------------
    */

    public function getfrontlink()
    {   
        $padt = PracticeArea::where('id', $this->practiceArea)->first();
        $statedt = State::where('id', $this->state)->first();
        $countydt = County::where('id', $this->county)->where('type','County')->first();

        $pa = $padt->slug;
        $state = str_replace(' ', '-', strtolower($statedt->name));

        if($countydt != null){
            $county = str_replace(' ', '-', strtolower($countydt->name));
            
            return '<a href="' . url('lawyers/pa/'.$pa.'/'.$state.'/'.$county.'-county') . '" target="_blank">View</a>';
        }else{
            return '';
        }

    }

    /*
    |--------------------------------------------------------------------------
    | RELATIONS
    |--------------------------------------------------------------------------
    */

    public function practiceAreas()
    {
        return $this->belongsTo('App\Models\PracticeArea', 'practiceArea', 'id');
    }

    public function states()
    {
        return $this->belongsTo('App\Models\State', 'state', 'id');
    }

    public function counties()
    {
        return $this->belongsTo('App\Models\County', 'county', 'id');
    }

    /*
    |--------------------------------------------------------------------------
    | SCOPES
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | ACCESSORS
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | MUTATORS
    |--------------------------------------------------------------------------
    */
}
