<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\BlogCategoriesRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class BlogCategoriesCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class BlogCategoriesCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\BlogCategories::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/blog-categories');
        CRUD::setEntityNameStrings('blog categories', 'blog categories');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        CRUD::column('name');
        CRUD::column('slug');

        CRUD::column('parent_id')->label('Parent')
        ->type('select')
        ->name('parent_id')
        ->entity('parent')
        ->attribute('name')
        ->model('App\Models\BlogCategories');

        CRUD::column('created_at');
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(BlogCategoriesRequest::class);

        // METAS
        CRUD::field([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_title',
            'label'    => "Meta Title",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_description',
            'label'    => "Meta Description",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_keywords',
            'label'    => "Meta Keywords",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]); 

        CRUD::field('name')->type('text')->tab("Content");
        CRUD::field('slug')->type('text')->tab("Content");

        CRUD::field([
            'label'     => 'Parent',
            'type'      => 'select_grouped',
            'name'      => 'parent_id',
            'entity'    => 'parent',
            'attribute' => 'name',
            'group_by'  => 'parent',
            'group_by_attribute' => 'name',
            'group_by_relationship_back' => 'children',
            'tab' => 'Content',
        ]);

        CRUD::field([
            'name'  => 'content',
            'label' => 'Content',
            'type'  => 'summernote',
            'wrapper' => [
                'class' => 'form-group col-md-12',
            ],
            'tab' => 'Content',
        ]);
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
