// if nullable, make sure the Clear button uses the translated string
document.styleSheets[0].addRule('.select2-selection__clear::after','content:  "Clear";');


/**
 *
 * This method gets called automatically by Backpack:
 *
 * @param  node element The jQuery-wrapped "select" element.
 * @return void
 */
function bpFieldInitRelationshipSelectElement(element) {
    var $placeholder = element.attr('data-placeholder');
    var $multiple = element.attr('data-field-multiple')  == 'false' ? false : true;
    var $allows_null = (element.attr('data-column-nullable') == 'true') ? true : false;
    var $allowClear = $allows_null;
    var $isFieldInline = element.data('field-is-inline');
    var $isPivotSelect = element.data('is-pivot-select');
    
    const changePivotOptionState = function(pivotSelector, enable = true) {
        let containerName = getPivotContainerName(pivotSelector);
        let pivotsContainer = pivotSelector.closest('div[data-repeatable-holder="'+containerName+'"]');
        
        $(pivotsContainer).children().each(function(i,container) {
            $(container).find('select').each(function(i, el) {
                
                if(typeof $(el).attr('data-is-pivot-select') !== 'undefined' && $(el).attr('data-is-pivot-select')) {
                    if(pivotSelector.val()) {
                        if(enable) {
                            $(el).find('option[value="'+pivotSelector.val()+'"]').prop('disabled',false);   
                        }else{
                            if($(el).val() !== pivotSelector.val()) {
                                $(el).find('option[value="'+pivotSelector.val()+'"]').prop('disabled',true);
                            }
                        }
                    }
                }
            });
        });
    };

    const getPivotContainerName = function(pivotSelector) {
        let containerName = pivotSelector.data('repeatable-input-name')
        return containerName.substring(0, containerName.indexOf('['));
    }

    const disablePreviouslySelectedPivots = function(pivotSelector) {
        
        let containerName = getPivotContainerName(pivotSelector);
        let pivotsContainer = pivotSelector.closest('div[data-repeatable-holder="'+containerName+'"]');

        let selectedValues = [];
        let selectInputs = [];
        
        $(pivotsContainer).children().each(function(i,container) {
            $(container).find('select').each(function(i, el) {
                if(typeof $(el).attr('data-is-pivot-select') !== 'undefined' && $(el).attr('data-is-pivot-select') != "false") {
                    selectInputs.push(el);
                    if($(el).val()) {
                        selectedValues.push($(el).val());
                    }
                }
            });
        });

        selectInputs.forEach(function(input) {
            selectedValues.forEach(function(value) {
                if(value !== $(input).val()) {
                    $(input).find('option[value="'+value+'"]').prop('disabled',true);
                }
            });
        });
    };

    var $select2Settings = {
            theme: 'bootstrap',
            multiple: $multiple,
            placeholder: $placeholder,
            allowClear: $allowClear,
            dropdownParent: $isFieldInline ? $('#inline-create-dialog .modal-content') : $(document.body)
        };
    if (!$(element).hasClass("select2-hidden-accessible"))
    {
        $(element).select2($select2Settings);
        
        if($isPivotSelect) {
            disablePreviouslySelectedPivots($(element));
        }
    }

    if($isPivotSelect) {
        $(element).on('select2:selecting', function(e) {
            if($(this).val()) {
                changePivotOptionState($(this)); 
            }
            return true;
        });

        $(element).on('select2:select', function(e) {
            changePivotOptionState($(this), false);
            return true;
        });

        $(element).on('CrudField:delete', function(e) {
            changePivotOptionState($(this));
            return true;
        });
    }

}

