<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\BlogsRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class BlogsCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class BlogsCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Blogs::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/blogs');
        CRUD::setEntityNameStrings('blogs', 'blogs');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        CRUD::setFromDb();
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(BlogsRequest::class);
        
        // METAS
        CRUD::field([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_title',
            'label'    => "Meta Title",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_description',
            'label'    => "Meta Description",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_keywords',
            'label'    => "Meta Keywords",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]); 

        // CONTENT
        CRUD::field('name')->type('text')->tab("Content");
        CRUD::field('slug')->type('text')->tab("Content");

        CRUD::field([
            'label'        => "Featured Image",
            'name'         => "featured_image",
            'filename'     => null,
            'type'         => 'base64_image',
            'aspect_ratio' => 1,
            'crop'         => false,
            'src'          => NULL,
            'tab' => 'Content',
        ]);

        // IDs
        CRUD::field([
            'label'     => "Written By",
            'type'      => 'select2',
            'name'      => 'written_by',
            'entity'    => 'written',
            'model'     => "App\Models\User",
            'attribute' => 'name',
            'tab' => 'Content',
        ]);

        CRUD::field([
            'label'     => "Fact Checked By",
            'type'      => 'select2',
            'name'      => 'fact_checked_by',
            'entity'    => 'fact_check',
            'model'     => "App\Models\User",
            'attribute' => 'name',
            'tab' => 'Content',
        ]);

        // CRUD::field([
        //     'label'     => 'Categories',
        //     'type'      => 'select2_multiple',
        //     'name'      => 'categories',
        //     'entity'    => 'categories',
        //     'attribute' => 'name',
        //     'pivot'     => true,
        //     'model'     => "App\Models\BlogCategories",
        //     'tab'       => 'Content',
        // ]);

        CRUD::field([
            'label'     => 'Categories',
            'type'      => 'select_grouped',
            'name'      => 'category',
            'entity'    => 'parent',
            'attribute' => 'name',
            'group_by'  => 'parent',
            'group_by_attribute' => 'name',
            'group_by_relationship_back' => 'children',
            'tab' => 'Content',
        ]);
        
        CRUD::field([
            'name'  => 'content',
            'label' => 'Content',
            'type'  => 'summernote',
            'wrapper' => [
                'class' => 'form-group col-md-12',
            ],
            'tab' => 'Content',
        ]);

        CRUD::field([
            'name' => 'faqs',
            'label' => 'Faqs',
            'type' => 'repeatable',
            'fake' => true,
            'store_in' => 'extras',
            'tab' => 'Faqs',
            'fields' => [
                [
                    'name' => 'faq_title',
                    'type' => 'text',
                    'label' => 'FAQ Title',
                    'fake' => true,
                    'wrapper' => [ 'class' => 'form-group col-md-4', ],
                ],
                [
                    'name' => 'faq_description',
                    'type' => 'textarea',
                    'label' => 'FAQ Description',
                    'fake' => true,
                    'wrapper' => [ 'class' => 'form-group col-md-8', ],
                ],
            ],

            // optional
            'new_item_label' => 'Add FAQ',
            'init_rows' => 1,
            'max_rows' => 10,
        ]);
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
