<?php
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\PayPalController;
use App\Http\Controllers\SocialController;
use App\Http\Controllers\PageController; 
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


/*
|--------------------------------------------------------------------------
| Sitemap
|--------------------------------------------------------------------------
*/

// Route::get('/generate_sitemap', 'App\Http\Controllers\SitemapController@generate');
// Route::get('/{slug}.xml', 'App\Http\Controllers\SitemapController@view');

/*
|--------------------------------------------------------------------------
| Glossary
|--------------------------------------------------------------------------
*/

Route::get('/glossary-of-legal-terms', 'App\Http\Controllers\GlossaryController@index');
Route::get('/testbackup', 'App\Http\Controllers\Admin\BackupControllers@index');

/*
|--------------------------------------------------------------------------
| HEADER SEARCH
|--------------------------------------------------------------------------
*/

// Route::get('/?search={search_q}', 'App\Http\Controllers\PageController@header_search');

/*
|--------------------------------------------------------------------------
| LAWYERS
|--------------------------------------------------------------------------
*/
// Route::get('/forum','App\Http\Controllers\ForumController@index');

Route::get('/lawyers', 'App\Http\Controllers\lawyersController@lawyers');

// all practice areas
Route::get('/lawyers/all-practice-areas', 'App\Http\Controllers\lawyersController@all_p_areas');

// url = /lawyers/pa/ [PracticeArea]
Route::get('/lawyers/pa/{pa}', 'App\Http\Controllers\lawyersController@lawyers_pa');  

// url = /lawyers/loc/ [State]
Route::get('/lawyers/loc/{state}', 'App\Http\Controllers\lawyersController@lawyers_s');  

// url = /lawyers/loc/ [State] / [City | County]
Route::get('/lawyers/loc/{state}/{city}', 'App\Http\Controllers\lawyersController@lawyers_s_and_c'); 

// url = /lawyers/pa/ [PracticeArea] / [State]
Route::get('/lawyers/pa/{p_area}/{state}', 'App\Http\Controllers\lawyersController@lawyers_pa_and_s');  

// url = /lawyers/ [PracticeArea] / [State] / [city]
Route::get('/lawyers/pa/{p_area}/{state}/{city}', 'App\Http\Controllers\lawyersController@lawyers_pa_and_s_and_c'); 

// url = /lawyers/ [PA] || [State]
Route::get('/lawyers/{slug}', 'App\Http\Controllers\lawyersController@lawyer_old_pa_or_s_links'); 

// url = /lawyers/ [PA] || [State] / [County] || [City] || [PA]
Route::get('/lawyers/{slug}/{slug2}', 'App\Http\Controllers\lawyersController@lawyer_old_pa_and_s_links'); 

// url = /lawyers/ [PA] / [State] / [County] || [City]
Route::get('/lawyers/{slug}/{slug2}/{slug3}', 'App\Http\Controllers\lawyersController@lawyer_old_pa_and_s_and_c_links'); 

// url = /lawyers/ [PracticeArea] /  lawyer name - lawyer_id
Route::get('/lawyer/{slug}', 'App\Http\Controllers\lawyersController@profile');

//filter lawyer
// Route::get('/filter-lawyers', 'App\Http\Controllers\lawyersController@filterLawyers');



/*
|--------------------------------------------------------------------------
| Blogs
|--------------------------------------------------------------------------
*/

Route::get('/edu/', 'App\Http\Controllers\BlogController@blog_archive');
Route::get('/edu/{parent_cat}/{child_cat}/{post_slug}', 'App\Http\Controllers\BlogController@blog_single_p_c');  
Route::get('/edu/{parent_cat}/{post_slug}', 'App\Http\Controllers\BlogController@blog_single_p');  

Route::get('/author/{author_slug}', 'App\Http\Controllers\BlogController@blog_author');  



/*
|--------------------------------------------------------------------------
| Careers index
|--------------------------------------------------------------------------
*/

Route::get('/careers', 'App\Http\Controllers\JobController@careers_index');



/*
|--------------------------------------------------------------------------
| Job Apply
|--------------------------------------------------------------------------
*/

// url = /job/ [Job_id]
Route::get('/jobs/{job_id}', 'App\Http\Controllers\JobController@application_form'); 

/*
|--------------------------------------------------------------------------
| Paypal
|--------------------------------------------------------------------------
*/

Route::get('upgraded-to-premium-payment/paypal/payment', [PayPalController::class, 'payment'])->name('paypal.payment');
Route::get('upgraded-to-premium-payment/paypal/payment/success', [PayPalController::class, 'paymentSuccess'])->name('paypal.payment.success');
Route::get('upgraded-to-premium-payment/paypal/payment/cancel', [PayPalController::class, 'paymentCancel'])->name('paypal.payment/cancel');


/*
|--------------------------------------------------------------------------
| Social Login
|--------------------------------------------------------------------------
*/

// GOOGLE
Route::get('/google/redirect', [SocialController::class, 'redirectToGoogle'])->name('google.redirect');
Route::get('/google/callback', [SocialController::class, 'handleGoogleCallback'])->name('google.callback');

// LINKEDIN
Route::get('/linkedin/redirect', [SocialController::class, 'linkedinRedirect'])->name('linkedin.redirect');
Route::get('/linkedin/callback', [SocialController::class, 'linkedinCallback'])->name('linkedin.callback');


/*
|--------------------------------------------------------------------------
| PAGE TEMPLATES
|--------------------------------------------------------------------------
*/

Route::get('/register', 'App\Http\Controllers\PageController@all_register');
Route::get('/lawyer-register', 'App\Http\Controllers\PageController@lawyer_register');
Route::get('/my-account', 'App\Http\Controllers\PageController@my_account')->name('my_account');
Route::get('/verify-account', 'App\Http\Controllers\PageController@verify_account');
Route::get('/activate-account/{email_verification_token}', 'App\Http\Controllers\PageController@activate_account');
Route::get('/upgraded-to-premium-payment', 'App\Http\Controllers\PageController@upgraded_to_premium_payment')->name('paypal');

Route::get('/logout', function() {
	Session::forget('f_user_login');
	Session::forget('user_id');
	Session::forget('username');
	return redirect('/register');
});

Route::get('{page}/{subs?}', ['uses' => '\App\Http\Controllers\PageController@index'])
->where(['page' => '^(((?=(?!admin))(?=(?!\/)).))*$', 'subs' => '.*']);


/*
|--------------------------------------------------------------------------
| POST REQUESTS
|--------------------------------------------------------------------------
*/

// CONTACT
Route::post('contact', 'App\Http\Controllers\FormController@contactFormStore')->name('contact.store');

// USERS 
Route::post('user_register', 'App\Http\Controllers\FormController@user_register')->name('fuser.store');

// LAWYERS
// Route::post('lawyers_pagination', 'App\Http\Controllers\lawyersController@ic_lawyers_paginate')->name('lawyers.paginate');
Route::post('lawyer_register', 'App\Http\Controllers\FormController@lawyer_register')->name('lawyer.store');
Route::post('verify_doc_upload', 'App\Http\Controllers\FormController@verify_doc')->name('upload_doc.verify_doc');
Route::post('add_lawyer_review', 'App\Http\Controllers\lawyersController@add_lawyer_review')->name('add_review.lawyer_review');

// LAWYERS & USERS
Route::post('all_user_update', 'App\Http\Controllers\FormController@all_user_update')->name('all_users.all_user_update');
Route::post('login', 'App\Http\Controllers\FormController@login')->name('users.login');

// LAWYERS & USERS RESEND EMAIL VERIFICATION
Route::post('resend_email_verification', 'App\Http\Controllers\FormController@resend_email_verification')->name('resend_verification');

// HEADER SEARCH
Route::post('lawyers_search_pagination', 'App\Http\Controllers\PageController@ic_lawyers_search_paginate')->name('lawyers_search.paginate');

// REFERRAL
Route::post('referral', 'App\Http\Controllers\FormController@l_referral')->name('lawyers_search.referral');

// LAWYER CONTACT
Route::post('contact_lawyer', 'App\Http\Controllers\lawyersController@contact_lawyer')->name('lawyers.contact');

// Apply Job
Route::post('apply_job', 'App\Http\Controllers\JobController@apply_job')->name('apply.job');



/*
|--------------------------------------------------------------------------
| SEARCH REQUESTS
|--------------------------------------------------------------------------
*/

Route::post('top_filter', 'App\Http\Controllers\SearchController@top_search')->name('tf.search');
Route::post('header_search', 'App\Http\Controllers\SearchController@header_search')->name('header.search');

/*
|--------------------------------------------------------------------------
| Ajax select2
|--------------------------------------------------------------------------
*/

Route::post('/api/firm', 'App\Http\Controllers\Api\FirmController@index');
Route::post('/api/county', 'App\Http\Controllers\Api\CountyController@index');
Route::post('/api/city', 'App\Http\Controllers\Api\CityController@index');


//Forum


// short code
Route::get('/short-code-1', function () {
    return view('short-code-1');
});
Route::get('/short-code-2', function () {
    return view('short-code-2');
});