$(document).ready(function () {
	// tab js
	$('.lpm-tabs li').click(function () {
		$('.lpm-tabs li').removeClass('active');
		$('.lpm-content').removeClass('active');
		var tid = $(this).attr('tab');
		$(this).addClass('active');
		// $(this).parent().parent().parent().toggleClass('lpm-width');
		
		if($("#verify-account-model").length){
			if(tid == "personal-profile" || tid == "company-profile"){
				$("#verify-account-model").modal('show');
			}
		}

		$('#' + tid).addClass('active');
	});

	//  img upload js
	function readURL(input) {
		if (input.files && input.files[0]) {
			var reader = new FileReader();
			reader.onload = function (e) {
				$('.lpm-user-img img').attr('src', e.target.result);
			}
			reader.readAsDataURL(input.files[0]);
		}
	}

	$("#file").change(function () {
		var fileExtension = ['jpeg', 'jpg', 'png',];
		if ($.inArray($(this).val().split('.').pop().toLowerCase(), fileExtension) == -1) {
			alert("Only formats are allowed : " + fileExtension.join(', '));
		} else {
			readURL(this);
		}
	});

	// Feature your profile form modal popup

	$('.fyp-modal-link').click(function () {
		var modal_id = $(this).attr('data-target');
		$('.fyp-modal-wapper').modal('hide');
		$(modal_id).modal('show');
	})

	// Country Code Selection

	$("#mobile_code").intlTelInput({
		initialCountry: "in",
		separateDialCode: true,
	});

	// select box js
	function selectMoreAndMany(className) {
		$(className).each((q, v) => {
			$(v).select2({})
		})
	}

	$('#practice-areas-wapper').select2();

	// ADD BUTTON
	var wrapper = $(".lpm-fees-wapper .fees-box-card").html();
	$(".lpm-fees-wapper .add-new-button").click(function (e) {
		$('.lpm-fees-wapper .fees-box-card').append(wrapper)
		selectMoreAndMany(".fee-wapper");
	})
	$('.lpm-form-card').on("click", ".form-box-controls", function (e) {
		e.preventDefault();
		$(this).parent('div').remove();
	});
	var jap_wrapper = $(".jap-box-wapper .jap-box-card").html();
	$(".jap-box-wapper .add-new-button").click(function (e) {
		$('.jap-box-card').append(jap_wrapper)
		selectMoreAndMany(".district-wapper")
	})

	var addresses_wrapper = $(".lpm-address-wapper").html();
	$(".lpm-address-main .add-new-button").click(function (e) {
		$('.lpm-address-wapper').append(addresses_wrapper)
		// $(".lpm-address-wapper .custom-control").each((e,v)=>{
		// 	let randam = Math.floor(Math.random()*1000000)
		// 	$(v).find("input").attr("id",`customSwitch1${randam}`)
		// 	$(v).find("label").attr("for",`customSwitch1${randam}`)
		// })
	})
	var professional_wrapper = $(".professional-exp-wapper").html();
	$(".professional-exp-main .add-new-button").click(function (e) {
		$('.professional-exp-wapper').append(professional_wrapper)
	})
	var educational_wrapper = $(".educational-exp-wapper").html();
	$(".educational-exp-main .add-new-button").click(function (e) {
		$('.educational-exp-wapper').append(educational_wrapper)
	})
	var professional_assoc_wrapper = $(".professional-assoc-wapper").html();
	$(".professional-assoc-main .add-new-button").click(function (e) {
		$('.professional-assoc-wapper').append(professional_assoc_wrapper)
	})
	var publications_wrapper = $(".publications-wapper").html();
	$(".publications-main .add-new-button").click(function (e) {
		$('.publications-wapper').append(publications_wrapper)
	})
	var website_blog_wrapper = $(".website-blog-wapper").html();
	$(".website-blog-main .add-new-button").click(function (e) {
		$('.website-blog-wapper').append(website_blog_wrapper)
	})
	var social_networks_wrapper = $(".social-networks-wapper").html();
	$(".social-networks-main .add-new-button").click(function (e) {
		$('.social-networks-wapper').append(social_networks_wrapper)
	})

	selectMoreAndMany(".firm-wapper");
	selectMoreAndMany(".fee-wapper");
	selectMoreAndMany(".district-wapper")

	/* Personal Profile Toc Start */
	let e, elems, last_h2;
	elems = document.querySelectorAll('#personal-profile .lpm-form-wapper .lpm-form-title-1 h3, #personal-profile .lpm-form-wapper .lpm-form-title h3 ')
	var sub_ul=0;
	var h2=1;
	for (e =0; e < elems.length; e++) {
		if (elems[e].localName === 'h3'){
			if(elems[e].innerHTML != "" && elems[e].innerHTML != "&nbsp;"){
				elems[e].setAttribute('id', 'i-scroll-'+e);
				if(e != elems.length-1){
					jQuery(".personal-profile-toc ul").append("<li class='sub-li sb-e-"+e+"'><a href='#i-scroll-"+e+"' class='sub-a'>"+elems[e].innerHTML.replace(/<[^>]*>/g, "")+"</a></li>");	
				}else{
					jQuery(".personal-profile-toc ul").append("<li class='sub-li sb-e-"+e+"'><a href='#i-scroll-"+e+"' class='sub-a'>"+elems[e].innerHTML.replace(/<[^>]*>/g, "")+"</a></li>");
				}
				last_h2=e;
				h2=h2+1;
			}
		}
	}
	var scrollLink = jQuery('.personal-profile-toc ul li a');
	scrollLink.click(function(e) {
		$('.personal-profile-toc ul').removeClass('active-p-toc')
		var title_name_a = $(this).html();
		$(this).parent().parent().parent().find('.personal-profile-toc-title span').text(title_name_a);
		e.preventDefault();
		jQuery('body,html').animate({
			scrollTop: jQuery(this.hash).offset().top - 100
		}, 1000 );
	});
	jQuery(window).scroll(function() {
		var scrollbarLocation = jQuery(this).scrollTop();
		scrollLink.each(function() {
			var sectionOffset = jQuery(this.hash).offset().top - 150;
			if ( sectionOffset <= scrollbarLocation ) {
				jQuery(this).parent().addClass('active');
				jQuery(this).parent().siblings().removeClass('active');
				var title_name = $(this).parent().addClass('active').find('a').html();
				$(this).parent().parent().parent().find('.personal-profile-toc-title span').text(title_name);
			}

		});
	});

	$('.personal-profile-toc-title').click(function(){
		$('.personal-profile-toc ul').toggleClass('active-p-toc')
	})

	/* Personal Profile Toc End */

	/*
	|--------------------------------------------------------------------------
	| FORMS SUBMISSIONS
	|--------------------------------------------------------------------------
	*/

	// SHOW SUCCESS OR ERROR TOAST
	function show_snak(class_nm, mssg) {
		jQuery("#snackbar").addClass(class_nm);
		jQuery("#snackbar").addClass("show");
		jQuery("#snackbar").html(mssg);

		setTimeout(function () { jQuery("#snackbar").removeClass("show"); jQuery("#snackbar").removeClass(class_nm); }, 3000);
	}

	// HIDE ERRORS ON LOAD
	jQuery(".my-account .err").text("");
	jQuery(".my-account .err").fadeOut();
	jQuery(".my-account .form_res").fadeOut();
	jQuery(".my-account .form_res #form_loading").fadeOut();
	jQuery(".my-account .form_res #user_form_message").fadeOut();

	function u_errorFadeIn(text, ele) {
		jQuery(ele).parent().find(".err").fadeIn();
		jQuery(".err").css("color", "#b70c0c");
		jQuery(ele).parent().find(".err").text(text);
		setTimeout(() => {
			jQuery(".err").fadeOut();
		}, 5000);
		return false;
	}

	function u_errorFadeOut() {
		jQuery(".my-account .err").fadeOut();
		jQuery(".my-account .err").css("color", "#fff");
		jQuery(".my-account .err").text("");
	}

	// PHONE INPUT
	jQuery('#l_phone').on('propertychange input', function (e) {
		var x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
		e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
	});

	// CHECK IS EMAIL
	function u_isEmail(email) {
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		return regex.test(email);
	}

	// SHOW HIDE PASSWORD
	jQuery('#user_pass_view').click(function () {
		if ('password' == jQuery('#user_password').attr('type')) {
			jQuery('#user_password').prop('type', 'text');
		} else {
			jQuery('#user_password').prop('type', 'password');
		}
	});

	// GENERAL FORM SUBMISSION
	$("#gen_submit").click(function (e) {
		e.preventDefault();
		var user_name = $("#general-profile #gen_uname").val();
		var user_email = $("#general-profile #gen_email").val();
		var user_password = $("#general-profile #gen_pass").val();

		if (user_name.length == 0 || user_name.length < 2) {
			u_errorFadeIn("Enter valid name.", "#general-profile #gen_uname");
		} else if (user_email.length == 0) {
			u_errorFadeIn("Enter your email addresss", "#general-profile #gen_email");
		} else if (!u_isEmail(user_email)) {
			u_errorFadeIn("Enter valid email addresss", "#general-profile #gen_email");
		} else if (user_password.length > 0 && user_password.length < 5) {
			u_errorFadeIn("Enter valid password. It should be 4 character long", "#general-profile #gen_pass");
		} else {
			u_errorFadeOut(".error");
			jQuery(".form_res").fadeIn();
			jQuery(".form_res #form_loading").fadeIn();

			$("#general-profile").css("opacity", "0.8");
			var form_data = { "user_name": "", "user_email": "", "user_password": "", "c_user_id": $("#cur_u_id").val(), "user_type": "subscriber" };

			form_data.user_name = $("#general-profile #gen_uname").val();
			form_data.user_email = $("#general-profile #gen_email").val();
			form_data.user_password = $("#general-profile #gen_pass").val();

			ajaxSend(form_data, all_user_update, 'subscriber');
		}
	});

	// LAWYER PERSONAL SUBMIT
	$("#personal_submit").click(function (e) {
		e.preventDefault();
		var form_data = { "personal_info": {}, "biography": {}, "fees_info": {}, "jurisdictions": {}, "addresses": {}, "professional_experiences": {}, "educational_experiences": {}, "professional_associations": {}, "publications": {}, "websites": {}, "social": {}, "c_user_id": $("#cur_u_id").val(), "user_type": "lawyer_personal" };

		var user_image = $('#personal-profile .lpm-user-img img').attr("src");
		var l_prefix = $("#personal-profile #l_prefix").val();
		var l_fname = $("#personal-profile #l_fname").val();
		var l_middle_name = $("#personal-profile #l_middle_name").val();
		var l_last_name = $("#personal-profile #l_last_name").val();
		var l_sufffix = $("#personal-profile #l_sufffix").val();
		var l_email = $("#personal-profile #l_email").val();
		var l_website = $("#personal-profile #l_website").val();
		var l_phone = $("#personal-profile #l_phone").val();
		var l_fax = $("#personal-profile #fax_code").val();
		var l_firms = $("#personal-profile #firm-wapper").val();
		// var l_experience = $("#personal-profile #l_experience").val();
		var l_practice_area = $("#personal-profile #practice-areas-wapper").val();
		var description = $("#personal-profile #summernote").val();

		form_data.personal_info['user_image'] = user_image;
		form_data.personal_info['l_prefix'] = l_prefix;
		form_data.personal_info['l_fname'] = l_fname;
		form_data.personal_info['l_middle_name'] = l_middle_name;
		form_data.personal_info['l_last_name'] = l_last_name;
		form_data.personal_info['l_sufffix'] = l_sufffix;
		form_data.personal_info['l_email'] = l_email;
		form_data.personal_info['l_website'] = l_website;
		form_data.personal_info['l_phone'] = l_phone;
		form_data.personal_info['l_fax'] = l_fax;
		form_data.personal_info['l_firms'] = l_firms;
		// form_data.personal_info['l_experience'] = l_experience;
		form_data.personal_info['l_practice_area'] = l_practice_area;
		form_data.personal_info['l_fax'] = l_fax;

		form_data.biography['description'] = description;

		// FEES
		var lfi = 0;
		$(".lpm-fees-wapper .fees-box-wapper").each(function () {
			form_data.fees_info["fee_" + lfi] = {
				"l_fees": $(this).find('#fee-wapper').val(),
				"l_fee_description": $(this).find('#l_fee_description').val(),
			}
			lfi++;
		});

		// jurisdictions
		var lju = 0;
		$(".jap-box-wapper .fees-box-wapper").each(function () {
			form_data.jurisdictions["j_" + lju] = {
				"l_court_name": $(this).find('#l_court_name').val(),
				"l_court_dist": $(this).find('#district-wapper').val(),
				"l_court_since": $(this).find('#l_court_since').val(),
			}
			lju++;
		});

		// Addresses
		var ladd = 0;
		$(".lpm-address-card").each(function () {
			var primary = "no";
			if ($(this).find('#customSwitch1').is(':checked')) {
				var primary = "yes";
			}
			form_data.addresses["j_" + ladd] = {
				"l_address_label": $(this).find('#l_address_label').val(),
				"l_address_full": $(this).find('#l_address_full').val(),
				"l_address_city": $(this).find('#l_address_city').val(),
				"l_address_county": $(this).find('#l_address_county').val(),
				"l_address_state": $(this).find('#l_address_state').val(),
				"l_address_country": $(this).find('#l_address_country').val(),
				"l_address_zip": $(this).find('#l_address_zip').val(),
				"l_address_primary": primary,
			}
			ladd++;
		});

		// Professional Experiences
		var lpexp = 0;
		$(".lpm-professional-exp-card").each(function () {
			form_data.professional_experiences["j_" + lpexp] = {
				"l_exp_position": $(this).find('#l_exp_position').val(),
				"l_exp_employer": $(this).find('#l_exp_employer').val(),
				"l_exp_year_start": $(this).find('#l_exp_year_start').val(),
				"l_exp_year_end": $(this).find('#l_exp_year_end').val(),
			}
			lpexp++;
		});

		// Educational Experiences
		var leduexp = 0;
		$(".lpm-educational-exp-card").each(function () {
			form_data.educational_experiences["j_" + leduexp] = {
				"l_edu_exp_institute": $(this).find('#l_edu_exp_institute').val(),
				"l_edu_exp_title": $(this).find('#l_edu_exp_title').val(),
				"l_edu_exp_year_start": $(this).find('#l_edu_exp_year_start').val(),
				"l_edu_exp_year_end": $(this).find('#l_edu_exp_year_end').val(),
				"l_edu_exp_activities": $(this).find('#l_edu_exp_activities').val(),
				"l_edu_exp_honors": $(this).find('#l_edu_exp_honors').val(),
			}
			leduexp++;
		});

		// Professional Associations
		var lpasso = 0;
		$(".lpm-professional-assoc-card").each(function () {
			form_data.professional_associations["j_" + lpasso] = {
				"l_pro_asso_position": $(this).find('#l_pro_asso_position').val(),
				"l_pro_asso_institute": $(this).find('#l_pro_asso_institute').val(),
				"l_pro_asso_year_start": $(this).find('#l_pro_asso_year_start').val(),
				"l_pro_asso_year_end": $(this).find('#l_pro_asso_year_end').val(),
			}
			lpasso++;
		});

		// Publications
		var lpub = 0;
		$(".lpm-publications-card").each(function () {
			form_data.publications["j_" + lpub] = {
				"l_pub_title": $(this).find('#l_pub_title').val(),
				"l_pub_link": $(this).find('#l_pub_link').val(),
				"l_pub_medium": $(this).find('#l_pub_medium').val(),
				"l_pub_date": $(this).find('#l_pub_date').val(),
			}
			lpub++;
		});

		// Website & Blog Entries
		var lwebs = 0;
		$(".lpm-website-blog-card").each(function () {
			form_data.websites["j_" + lwebs] = {
				"l_web_type": $(this).find('#type-wapper').val(),
				"l_web_title": $(this).find('#l_web_title').val(),
				"l_web_link": $(this).find('#l_web_link').val(),
				"l_web_date": $(this).find('#l_web_date').val(),
			}
			lwebs++;
		});

		// Social
		var lsocial = 0;
		$(".lpm-social-networks-card").each(function () {
			form_data.social["j_" + lsocial] = {
				"l_social_type": $(this).find('#social-wapper').val(),
				"l_social_link": $(this).find('#l_social_link').val(),
			}
			lsocial++;
		});

		// VALIDATE
		if (user_image == "" || l_prefix == "" || l_fname == "" || l_middle_name == "" || l_last_name == "" || l_email == "" || l_phone == "" || l_practice_area == "" || description == "") {
			show_snak("err", "All Fields are Required");

			$.each($('#personal-profile input.required'), function () {
				if ($(this).val() == "") {
					$(this).addClass("field_error");
				} else {
					$(this).removeClass("field_error");
				}
			});

			$.each($('#personal-profile select.required'), function () {
				if ($(this).val() == "") {
					$(this).parent().find(".select2-container").addClass("field_error");
				} else {
					$(this).parent().find(".select2-container").removeClass("field_error");
				}
			});

			$.each($('#personal-profile textarea.required'), function () {
				if ($(this).val() == "") {
					$(this).addClass("field_error");
				} else {
					$(this).removeClass("field_error");
				}
			});

			$('html, body').animate({ scrollTop: $("#personal-profile .required").first().offset().top }, 2000);
		} else {
			jQuery(".floading").css("display", "unset");
			ajaxSend(form_data, all_user_update, 'lawyer_personal');
		}
	});

	// company_profile
	// PHONE INPUT
	jQuery('#company_phone').on('propertychange input', function (e) {
		var x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
		e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
	});

	$("#company_submit").click(function (e) {
		e.preventDefault();
		var form_data = { "company_info": {},"c_user_id": $("#cur_u_id").val(), "user_type": "lawyer_company" };

		var company_name = $("#company-profile #company_name").val();
		var company_description = $("#company-profile #company_description").val();
		var company_email = $("#company-profile #company_email").val();
		var company_phone = $("#company-profile #company_phone").val();
		var company_fax = $("#company-profile #company_fax").val();
		var company_url = $("#company-profile #company_url").val();
		var company_addr_1 = $("#company-profile #company_addr_1").val();
		var company_addr_2 = $("#company-profile #company_addr_2").val();
		var company_city = $("#company-profile #company_city").val();
		var company_county = $("#company-profile #company_county").val();
		var company_state = $("#company-profile #company_state").val();
		var company_country = $("#company-profile #company_country").val();

		form_data.company_info['company_name'] = company_name;
		form_data.company_info['company_description'] = company_description;
		form_data.company_info['company_email'] = company_email;
		form_data.company_info['company_phone'] = company_phone;
		form_data.company_info['company_fax'] = company_fax;
		form_data.company_info['company_url'] = company_url;
		form_data.company_info['company_addr_1'] = company_addr_1;
		form_data.company_info['company_addr_2'] = company_addr_2;
		form_data.company_info['company_city'] = company_city;
		form_data.company_info['company_county'] = company_county;
		form_data.company_info['company_state'] = company_state;
		form_data.company_info['company_country'] = company_country;

			// VALIDATE
		if (company_name == "" || company_description == "" || company_email == "" || company_phone == "" || company_url == "" || company_addr_1 == "" || company_city == "" || company_county == "" || company_state == "" || company_country == "") {
			show_snak("err", "All Fields are Required");

			$.each($('#company-profile input.required'), function () {
				if ($(this).val() == "") {
					$(this).addClass("field_error");
				} else {
					$(this).removeClass("field_error");
				}
			});

			$.each($('#company-profile textarea.required'), function () {
				if ($(this).val() == "") {
					$(this).addClass("field_error");
				} else {
					$(this).removeClass("field_error");
				}
			});

			$('html, body').animate({ scrollTop: $("#company-profile .required").first().offset().top }, 2000);
		}else {
			jQuery(".floading").css("display", "unset");
			ajaxSend(form_data, all_user_update, 'lawyer_company');
		}
	});

	function ajaxSend(data, url, type) {
		$.ajaxSetup({
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		});

		$.ajax({
			url: url,
			type: "POST",
			data: data,
			dataType: 'json',
			success: function (response) {
				jQuery(".form_res #form_loading").fadeOut();

				if (type == 'subscriber') {
					if (response.error == "") {
						jQuery(".form_res #user_form_message").text(response.success);
						jQuery(".form_res #user_form_message").fadeIn();

						setTimeout(function () {
							jQuery(".err").text("");
							jQuery(".err").fadeOut();
							jQuery(".form_res").fadeOut();
							jQuery(".form_res #user_form_message").text("");
							jQuery(".form_res #user_form_message").fadeOut();
							jQuery('#general-profile').css("opacity", "1");
						}, 2000);

					} else {
						jQuery('#general-profile').css("opacity", "1");
						jQuery(".form_res").fadeOut();

						if (response.e_code == "e_exists") {
							u_errorFadeIn(response.error, "#gen_email");
						}
					}
				}

				if (type == 'lawyer_personal') {
					jQuery(".floading").css("display", "none");

					if (response.error == "") {
						show_snak("success", "User Updated");
					} else {
						show_snak("err", "Something Went Wrong");
					}
				}

				if (type == 'lawyer_company') {
					jQuery(".floading").css("display", "none");

					if (response.error == "") {
						show_snak("success", response.success);
					} else {
						show_snak("err", response.error);
					}
				}
			},
		});
	}
});	