$(document).ready(function(){

	$(".error").fadeOut();

	function errorFadeIn(text) {
		$(".error").fadeIn();
		jQuery(".error").css("color", "#2D4E66");
		jQuery(".error").text(text);
		setTimeout(() => {
			$(".error").fadeOut();
		}, 3000);
		return false;
	}

	function errorFadeOut() {
		$(".error").fadeOut();
		jQuery(".error").css("color", "#fff");
		jQuery(".error").text("");
	}

	$('.lawyer-profile-bottom-v').click(function(){
		$(this).toggleClass('active');
		$('.lawyer-profile-right').toggleClass('active');
	})

	// CHECK IS EMAIL
	function isEmail(email) {
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		return regex.test(email);
	}

	/* rating js start*/
	function l_profile_star_rating(){
		$('.lawyer-profile-stars-rating').each(function (event) {
			var rating = $(this).attr('rating');
			var i;
			for(i = 0; (i < rating); i++) {
				$(this).find('span.star').eq(i).addClass('filled');
			}
			if(rating % 1>0)
				$(this).find('span.star').eq(i-1).addClass('half-filled');
		});
	}
	l_profile_star_rating();

	function s_profile_star_rating(){
		$('.sln-content-stars-rating').each(function (event) {
			var rating = $(this).attr('rating');
			var i;
			for(i = 0; (i < rating); i++) {
				$(this).find('span.star').eq(i).addClass('filled');
			}
			if(rating % 1>0)
				$(this).find('span.star').eq(i-1).addClass('half-filled');
		});
	}
	s_profile_star_rating();
	/* rating js end */

	// tab js
	$('.lawyer-tab-a').click(function(){  
		$(".lawyer-tab").removeClass('lawyer-tab-active');
		$(".lawyer-tab[data-id='"+$(this).attr('data-id')+"']").addClass("lawyer-tab-active");
		$(".lawyer-tab-a").removeClass('lawyer-active-a');
		$(this).parent().find(".lawyer-tab-a").addClass('lawyer-active-a');
	});

	// text showmore js
	$('[data-show="more"]').on('click', function(event) {
		event.preventDefault();
		if ( $(this).attr('more-collapse') === 'false' ) {     
			$(this).attr('more-collapse', 'true'); 
			$(this).prev('.more-text').removeClass('hide');
			$(this).text('less');
		}  else {
			$(this).text('more');
			$(this).attr('more-collapse', 'false'); 
			$(this).prev('.more-text').addClass('hide');
		}  
	});   


	/* reviews rating js start*/
	function l_reviews_star_rating(){
		$('.lawyer-reviews-stars-rating').each(function (event) {
			var rating = $(this).attr('rating');
			var i;
			for(i = 0; (i < rating); i++) {
				$(this).find('span.star').eq(i).addClass('filled');
			}
			if(rating % 1>0)
				$(this).find('span.star').eq(i-1).addClass('half-filled');
		});
	}
	l_reviews_star_rating();

	// Write review start hover js
	jQuery('#stars li ').on('mouseover', function(){
		var onStar = parseInt(jQuery(this).data('value'), 10);
		jQuery(this).parent().children('li.star').each(function(e){
			if (e < onStar) {
				jQuery(this).addClass('hover');
			}
			else {
				jQuery(this).removeClass('hover');
			}
		});    
	}).on('mouseout', function(){
		jQuery(this).parent().children('li.star').each(function(e){
			jQuery(this).removeClass('hover');
		});
	});
	jQuery('#stars li').on('click', function(){
		var onStar = parseInt(jQuery(this).data('value'), 10);
		$("#l_rev_rating").val(onStar);
		var stars = jQuery(this).parent().children('li.star');
		for (i = 0; i < stars.length; i++) {
			jQuery(stars[i]).removeClass('selected');
		}
		for (i = 0; i < onStar; i++) {
			jQuery(stars[i]).addClass('selected');
		}
	});


	// Claim your profile modal popup
	$('.claim-profile p').click(function(){
		var modal_id = $(this).attr('data-target');
		$('.cyp-modal-wapper').modal('hide');
		$(modal_id).modal('show');
	});

	// LAWYER REVIEW SUBMIT
	$('#l_rev_submit').click(function(e){
		e.preventDefault();
		var rate = $("#l_rev_rating").val();
		var rev_comment = $("#l_rev_comment").val();
		var rev_u_id = $("#l_rev_usr_id").val();
		var rev_l_id = $("#l_rev_list_id").val();

		if(rate == ""){
			$(".l_rev_err").text("Please Rate Us...");
		}else if(rev_comment == ""){
			$(".l_rev_err").text("Please Write Something...");
		}else if(rev_u_id == "" || rev_l_id == ""){
			$(".l_rev_err").text("Something went wrong...");
		}else{
			$(".l_rev_err").text("");
			$("#write-review-modal .modal-body").css({"opacity":"0.5","pointer-events":"none"});

			$.ajax({
				url: law_review,
				type: "POST",
				data:{"rate":rate, "rev_comment":rev_comment, "rev_u_id":rev_u_id,"rev_l_id":rev_l_id},
				dataType: "json",
				success:function(data){
					$("#write-review-modal .modal-body").css({"opacity":"1"});

					if(data.error == ""){
						$(".l_rev_success").text(data.success);
						$(".lawyer-reviews-row").html(data.all_rev_html);
						$(".l_tot_rev").html(data.total_reviews);
						l_profile_star_rating();
						l_reviews_star_rating();
						$('#write-review-modal').modal('hide');
					}else{
						$(".l_rev_err").text(data.error);
					}
				}
			});
		}
	});

	$('#contact_submit').click(function(e){
		e.preventDefault();
		var first_name = $("#first_name").val();
		var last_name = $("#last_name").val();
		var email = $("#email").val();
		var subject = $("#subject").val();
		var zip = $("#zip").val();
		var contact_summary = $("#contact_summary").val();
		var lawyer_id = $("#lawyer_id").val();

		const formData = new FormData();
		formData.append("first_name", first_name);
		formData.append("last_name", last_name);
		formData.append("email", email);
		formData.append("subject", subject);
		formData.append("zip", zip);
		formData.append("contact_summary", contact_summary);
		formData.append("lawyer_id", lawyer_id);

		if(first_name == "" || last_name == "" || email == "" || subject == "" || zip == ""){
			errorFadeIn("All Fields are Required");
		}else if(!isEmail(email)){
			errorFadeIn("Enter valid email addresss");
		}else if(lawyer_id == ""){
			errorFadeIn("Something went wrong");
		}else{
			errorFadeOut();

			jQuery("#contact_form").css("opacity", "0.8");

			$.ajaxSetup({
				headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			});
			$("#ref_form_submit").attr("disabled", true);
			$.ajax({
				url: law_contact,
				type: "POST",
				data: formData,
				processData: false,
				contentType: false,
				success: function (response) {
					var response = JSON.parse(response);
					jQuery("#contact_form").css("opacity", "1");

					if(response.error == ""){
						jQuery("#contact_form .error").text(response.success);
						jQuery("#contact_form .error").fadeIn();

						setTimeout(function(){ 
							jQuery("#contact_form .error").text("");
							jQuery("#contact_form .error").fadeOut();
						}, 2000);
					}else{
						jQuery(".form_res").fadeOut();
						jQuery("#contact_form .error").text(response.error);
					}
				},
			});
		}
	});
});