<?php
namespace App;

/*
|--------------------------------------------------------------------------
| Page Templates for Backpack\PageManager
|--------------------------------------------------------------------------
|
| Each page template has its own method, that define what fields should show up using the Backpack\CRUD API.
| Use snake_case for naming and PageManager will make sure it looks pretty in the create/update form
| template dropdown.
|
| Any fields defined here will show up after the standard page fields:
| - select template
| - page name (only seen by admins)
| - page title
| - page slug
| - url_index
*/

trait PageTemplates
{

    private function about_us()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // SECTION 1
        $this->crud->addField([
            'name' => 'section_1_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 1</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'section_1_title',
            'label' => 'Section 1 Title',
            'type' => 'text',
            'fake' => true,
            'placeholder' => trans('backpack::pagemanager.content_placeholder'),
        ]);
        $this->crud->addField([
            'name' => 'section_1_bc',
            'label' => 'Section 1 Background',
            'type' => 'base64_image',
            'fake' => true,
            'filename' => null,
            'aspect_ratio' => 1,
            'crop' => false,
            'src' => NULL,
        ]);
        $this->crud->addField([
            'name' => 'section_1_content',
            'label' => 'Section 1 Content',
            'type' => 'summernote',
            'fake' => true,
            'placeholder' => trans('backpack::pagemanager.content_placeholder'),
        ]);

        // SECTION 2
        $this->crud->addField([
            'name' => 'section_2_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 2</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'section_2',
            'label' => 'AboutUs',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'about_point_img',
                    'label' => 'About Point Image',
                    'fake' => true,
                    'filename' => null,
                    'type' => 'base64_image',
                    'aspect_ratio' => 1,
                    'crop' => false,
                    'src' => NULL,
                ],
                [
                    'name' => 'about_point_title',
                    'type' => 'text',
                    'label' => 'About Point Title',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-4'],
                ],
                [
                    'name' => 'about_point_details',
                    'type' => 'ckeditor',
                    'label' => 'About Point Details',
                    'fake' => true,
                ],
            ],

            // optional
            'new_item_label' => 'Add Group',
            'init_rows' => 1,
            'min_rows' => 4,
            'max_rows' => 4,
        ]);

        // SECTION 3
        $this->crud->addField([
            'name' => 'section_3_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 3</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'section_3_title',
            'type' => 'text',
            'label' => 'Section 3 Title',
            'fake' => true,
        ]);
        $this->crud->addField([
            'name' => 'section_3_reviews',
            'label' => 'Reviews',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'review_description',
                    'type' => 'ckeditor',
                    'label' => 'Review Description',
                    'fake' => true,
                ],
                [
                    'name' => 'review_name',
                    'type' => 'text',
                    'label' => 'Reviewer Name',
                    'fake' => true,
                ],
                [
                    'name' => 'rate_stars',
                    'label' => 'Rating Stars',
                    'type' => 'number',
                    'fake' => true,
                ]
            ],

            // optional
            'new_item_label' => 'Add review',
            'init_rows' => 1,
            'min_rows' => 2,
            'max_rows' => 2,
        ]);

        // SECTION 4
        $this->crud->addField([
            'name' => 'section_4_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 4</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'section_4_title',
            'type' => 'text',
            'label' => 'Section 4 Title',
            'fake' => true,
        ]);
        $this->crud->addField([
            'name' => 'section_4_description',
            'type' => 'summernote',
            'label' => 'Section 4 Description',
            'fake' => true,
        ]);
        $this->crud->addField([
            'name' => 'section_4_faqs',
            'label' => 'Faqs',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'faq_title',
                    'type' => 'text',
                    'label' => 'FAQ Title',
                    'fake' => true,
                ],
                [
                    'name' => 'faq_description',
                    'type' => 'summernote',
                    'label' => 'FAQ Description',
                    'fake' => true,
                ],
            ],

            // optional
            'new_item_label' => 'Add FAQ',
            'init_rows' => 1,
            'max_rows' => 10,
        ]);
    }

    private function simple_page()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // PAGE CONTENT
        $this->crud->addField([
            'name' => 'page_content_seprator',
            'type' => 'custom_html',
            'value' => '<br><h2>Page Content</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'section_1_bc',
            'label' => 'Section 1 Background',
            'type' => 'base64_image',
            'fake' => true,
            'filename' => null,
            'aspect_ratio' => 1,
            'crop' => false,
            'src' => NULL,
        ]);
        $this->crud->addField([
            'name' => 'page_content',
            'label' => 'Page Content',
            'type' => 'summernote',
            'fake' => true,
            'placeholder' => trans('backpack::pagemanager.content_placeholder'),
        ]);

    }

    private function contact()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
            'tab' => 'Meta',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
            'tab' => 'Meta',
        ]);

        // FORM CONTENT
        $this->crud->addField([
            'name' => 'page_content_seprator',
            'type' => 'custom_html',
            'value' => '<br><h2>Page Content</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'short_content',
            'label' => 'Short Content',
            'type' => 'textarea',
            'fake' => true,
            'tab' => 'Content',
        ]);

        $this->crud->addField([
            'name' => 'lawyer_image',
            'label' => 'Lawyer Image',
            'type' => 'base64_image',
            'fake' => true,
            'filename' => null,
            'aspect_ratio' => 1,
            'crop' => false,
            'src' => NULL,
            'tab' => 'Content',
        ]);

        $this->crud->addField([
            'name' => 'form_upper_title',
            'type' => 'summernote',
            'label' => 'Form Upper Title',
            'fake' => true,
            'tab' => 'Content',
        ]);

        $this->crud->addField([
            'name' => 'form_desclaimer',
            'type' => 'summernote',
            'label' => 'Form Desclamier',
            'fake' => true,
            'tab' => 'Content',
        ]);

        // BOTTOM CONTENT
        $this->crud->addField([
            'name' => 'bottom_content',
            'type' => 'custom_html',
            'value' => '<br><h2>Bottom Content</h2><hr>',
            'tab' => 'Content',
        ]);

        $this->crud->addField([
            'name' => 'b_r_1_right',
            'label' => 'Bottom Row 1 Right Content',
            'type' => 'summernote',
            'fake' => true,
            'tab' => 'Content',
        ]);

        $this->crud->addField([
            'name' => 'b_r_1_left',
            'label' => 'Bottom Row 1 Left Content',
            'type' => 'summernote',
            'fake' => true,
            'tab' => 'Content',
        ]);

        $this->crud->addField([
            'name' => 'b_r_2_right',
            'label' => 'Bottom Row 2 Right Content',
            'type' => 'summernote',
            'fake' => true,
            'tab' => 'Content',
        ]);

        $this->crud->addField([
            'name' => 'b_r_2_left',
            'label' => 'Bottom Row 2 Left Content',
            'type' => 'summernote',
            'fake' => true,
            'tab' => 'Content',
        ]);

        // Email Ids
        $this->crud->addField([
            'name' => 'c_email_ids',
            'label' => 'Email Ids',
            'type' => 'repeatable',
            'fake' => true,
            'tab' => 'Email Ids',
            'fields' => [
                [
                    'name' => 'email_title',
                    'type' => 'text',
                    'label' => 'Email Title',
                    'fake' => true,
                ],
                [
                    'name' => 'email_id',
                    'type' => 'email',
                    'label' => 'Email Id',
                    'fake' => true,
                ],
            ],

            // optional
            'new_item_label' => 'Add Email',
            'init_rows' => 1,
            'max_rows' => 10,
        ]);

    }

    private function home()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // SECTION 1
        $this->crud->addField([
            'name' => 'section_1',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 1</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'search_form_title',
            'label' => 'Section 1 Title',
            'type' => 'summernote',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'section_1_short_description',
            'label' => 'Section 1 short Description',
            'type' => 'summernote',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'h2_after_short_description',
            'label' => 'H2 Title after Short Description',
            'type' => 'text',
            'fake' => true,
        ]);

        // SECTION 2
        $this->crud->addField([
            'name' => 'section_2',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 2</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'sec_2_hide',
            'label' => 'Hide This Section',
            'type' => 'checkbox',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'sec_2_title',
            'label' => 'Section 2 Title',
            'type' => 'text',
            'fake' => true,
        ]);

        // SECTION 3
        $this->crud->addField([
            'name' => 'section_3',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 3</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'sec_3_title',
            'label' => 'Section 3 Title',
            'type' => 'text',
            'fake' => true,
        ]);
    }

    private function lawyers()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // CONTENT
        $this->crud->addField([
            'name' => 'content',
            'type' => 'custom_html',
            'value' => '<br><h2>Page Content</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'short_content',
            'label' => 'Short Content',
            'type' => 'summernote',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'h2_after_short_description',
            'label' => 'H2 Title after Short Description',
            'type' => 'text',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'content_title',
            'type' => 'text',
            'label' => 'Content Title',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'full_content',
            'label' => 'Full Content',
            'type' => 'summernote',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'faq_main_title',
            'type' => 'text',
            'label' => 'FAQ Section Title',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'faqs',
            'label' => 'Faqs',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'faq_title',
                    'type' => 'text',
                    'label' => 'FAQ Title',
                    'fake' => true,
                ],
                [
                    'name' => 'faq_description',
                    'type' => 'summernote',
                    'label' => 'FAQ Description',
                    'fake' => true,
                ],
            ],

            // optional
            'new_item_label' => 'Add FAQ',
            'init_rows' => 1,
            'max_rows' => 10,
        ]);
    }

    private function register()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // SECTION 1
        $this->crud->addField([
            'name' => 'section_1',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 1</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'title_bottom_content',
            'label' => 'Title Bottom Content',
            'type' => 'summernote',
            'fake' => true,
        ]);

        // SECTION 2
        $this->crud->addField([
            'name' => 'section_2',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 2</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'section_2_title',
            'type' => 'text',
            'label' => 'Section 2 Title',
            'fake' => true,
        ]);
        $this->crud->addField([
            'name' => 'section_2_points',
            'label' => 'Section 2 Points',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'sec_2_point_img',
                    'label' => 'Section Point Image',
                    'fake' => true,
                    'filename' => null,
                    'type' => 'base64_image',
                    'aspect_ratio' => 1,
                    'crop' => false,
                    'src' => NULL,
                ],
                [
                    'name' => 'sec_2_point_title',
                    'type' => 'text',
                    'label' => 'Section 2 Point Title',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-4'],
                ],
                [
                    'name' => 'sec_2_point_details',
                    'type' => 'ckeditor',
                    'label' => 'Section 2 Point Details',
                    'fake' => true,
                ],
            ],

            // optional
            'new_item_label' => 'Add Point',
            'init_rows' => 1,
            'min_rows' => 4,
            'max_rows' => 4,
        ]);
    }

    private function lawyer_register()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // LEFT SECTION
        $this->crud->addField([
            'name' => 'left_section',
            'type' => 'custom_html',
            'value' => '<br><h2>Left Section</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'left_section_title',
            'type' => 'text',
            'label' => 'Left Section Title',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'left_section_content',
            'label' => 'Left Section Content',
            'type' => 'summernote',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'left_section_points',
            'label' => 'Left Section Points',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'left_sec_img',
                    'label' => 'Left Section Point Image',
                    'fake' => true,
                    'filename' => null,
                    'type' => 'base64_image',
                    'aspect_ratio' => 1,
                    'crop' => false,
                    'src' => NULL,
                ],
                [
                    'name' => 'left_sec_point_title',
                    'type' => 'text',
                    'label' => 'Left Section Point Title',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-4'],
                ],
                [
                    'name' => 'left_sec_point_details',
                    'type' => 'ckeditor',
                    'label' => 'Left Point Details',
                    'fake' => true,
                ],
            ],

            // optional
            'new_item_label' => 'Add Point',
            'init_rows' => 1,
            'min_rows' => 4,
            'max_rows' => 4,
        ]);
    }

    private function account()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);
    }

    private function verify_account()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // First SECTION
        $this->crud->addField([
            'name' => 'first_section',
            'type' => 'custom_html',
            'value' => '<br><h2>First Section</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'first_section_title',
            'type' => 'text',
            'label' => 'First Section Title',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'first_section_content',
            'label' => 'First Section Content',
            'type' => 'textarea',
            'fake' => true,
        ]);
    }

    private function header_search()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

    }

    private function legal_terms_glossary()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);
    }

    private function upgraded_to_premium()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // SECTION 1
        $this->crud->addField([
            'name' => 'section_1',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 1</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'section_1_title',
            'type' => 'text',
            'label' => 'Section 1 Title',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'section_1_content',
            'label' => 'Section 1 Content',
            'type' => 'textarea',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'section_1_points',
            'label' => 'Section 1 Points',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'section_1_point_title',
                    'type' => 'text',
                    'label' => 'Section 1 Point Title',
                    'fake' => true,
                ]
            ],

            // optional
            'new_item_label' => 'Add Point',
            'init_rows' => 1,
            'min_rows' => 4,
            'max_rows' => 6,
        ]);

        $this->crud->addField([
            'name' => 'section_1_button_text',
            'type' => 'text',
            'label' => 'Section 1 Button Text',
            'fake' => true,
            'wrapper' => ['class' => 'form-group col-md-6'],
        ]);

        $this->crud->addField([
            'name' => 'section_1_button_url',
            'type' => 'url',
            'label' => 'Section 1 Button Url',
            'fake' => true,
            'wrapper' => ['class' => 'form-group col-md-6'],
        ]);

        $this->crud->addField([
            'name' => 'section_1_left_img',
            'label' => 'Section 1 Left Image',
            'fake' => true,
            'filename' => null,
            'type' => 'base64_image',
            'aspect_ratio' => 1,
            'crop' => false,
            'src' => NULL,
        ]);


        // SECTION 2
        $this->crud->addField([
            'name' => 'section_2',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 2</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'section_2_title',
            'type' => 'text',
            'label' => 'Section 2 Title',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'section_2_content',
            'label' => 'Section 2 Content',
            'type' => 'textarea',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'section_2_points',
            'label' => 'Section 2 Points',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'sec_2_point_img',
                    'label' => 'Section Point Image',
                    'fake' => true,
                    'filename' => null,
                    'type' => 'base64_image',
                    'aspect_ratio' => 1,
                    'crop' => false,
                    'src' => NULL,
                    'wrapper' => ['class' => 'form-group col-md-2'],
                ],
                [
                    'name' => 'sec_2_point_title',
                    'type' => 'text',
                    'label' => 'Section 2 Point Title',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-5'],
                ],
                [
                    'name' => 'sec_2_point_details',
                    'type' => 'textarea',
                    'label' => 'Section 2 Point Details',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-5'],
                ],
            ],

            // optional
            'new_item_label' => 'Add Point',
            'init_rows' => 1,
            'min_rows' => 4,
            'max_rows' => 4,
        ]);


        // SECTION 3
        $this->crud->addField([
            'name' => 'section_3',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 3</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'section_3_title',
            'type' => 'text',
            'label' => 'Section 3 Title',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'section_3_features',
            'label' => 'Section 3 Features',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'sec_3_features_main_title',
                    'label' => 'Section 3 Features Main Title',
                    'type' => 'text',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-5'],
                ],
                [
                    'name' => 'sec_3_features_point_title',
                    'label' => 'Section 3 Features Point Title',
                    'type' => 'text',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-5'],
                ],
                [  
                    'name'  => 'sec_3_features_free',
                    'label' => 'Free',
                    'type'  => 'checkbox',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-1'],
                ],
                [  
                    'name'  => 'sec_3_features_premium',
                    'label' => 'Premium',
                    'type'  => 'checkbox',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-1'],
                ],
            ],

            // optional
            'new_item_label' => 'Add Feature',
            'init_rows' => 1,
        ]);

        // SECTION 3
        $this->crud->addField([
            'name' => 'section_4',
            'type' => 'custom_html',
            'value' => '<br><h2>Section 4</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'section_4_title',
            'type' => 'text',
            'label' => 'Section 4 Title',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'section_4_reviews',
            'label' => 'Section 4 Reviews',
            'type' => 'repeatable',
            'fake' => true,
            'fields' => [
                [
                    'name' => 'sec_3_author',
                    'type' => 'text',
                    'label' => 'Reviewer Name',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-5'],
                ],
                [
                    'name' => 'sec_3_reviews',
                    'type' => 'number',
                    'label' => 'Review',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-5'],
                ],
                [
                    'name' => 'sec_3_review_content',
                    'type' => 'textarea',
                    'label' => 'Review Content',
                    'fake' => true,
                    'wrapper' => ['class' => 'form-group col-md-12'],
                ],
            ],

            // optional
            'new_item_label' => 'Add Point',
            'init_rows' => 1,
            'min_rows' => 4,
            'max_rows' => 4,
        ]);
    }

    private function upgraded_to_premium_payment()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);
    }

    private function all_practice_areas()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // CONTENT
        $this->crud->addField([
            'name' => 'content',
            'type' => 'custom_html',
            'value' => '<br><h2>Page Content</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'short_content',
            'label' => 'Short Content',
            'type' => 'summernote',
            'fake' => true,
        ]);

        $this->crud->addField([
            'name' => 'h2_after_short_description',
            'label' => 'H2 Title after Short Description',
            'type' => 'text',
            'fake' => true,
        ]);
    }

    private function blogs_edu()
    {
        // METAS
        $this->crud->addField([
            'name' => 'metas_separator',
            'type' => 'custom_html',
            'value' => '<br><h2>' . trans('backpack::pagemanager.metas') . '</h2><hr>',
        ]);
        $this->crud->addField([
            'name' => 'meta_title',
            'label' => trans('backpack::pagemanager.meta_title'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([
            'name' => 'meta_description',
            'label' => trans('backpack::pagemanager.meta_description'),
            'fake' => true,
            'store_in' => 'extras',
        ]);

        $this->crud->addField([
            'name' => 'meta_keywords',
            'type' => 'textarea',
            'label' => trans('backpack::pagemanager.meta_keywords'),
            'fake' => true,
            'store_in' => 'extras',
        ]);
        $this->crud->addField([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'store_in' => 'extras',
            'fake' => true,
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        // CONTENT
        $this->crud->addField([
            'name' => 'content',
            'type' => 'custom_html',
            'value' => '<br><h2>Page Content</h2><hr>',
        ]);

        $this->crud->addField([
            'name' => 'short_content',
            'label' => 'Short Content',
            'type' => 'summernote',
            'fake' => true,
        ]);
    }
}