{{-- show_verification_docs_field field --}}
@php
$field['value'] = old_empty_or_null($field['name'], '') ?? ($field['value'] ?? ($field['default'] ?? ''));
@endphp

@include('crud::fields.inc.wrapper_start')
<label>{!! $field['label'] !!}</label>
@include('crud::fields.inc.translatable_icon')

@if($entry->job_id != "")
@php
$job_id = $entry->job_id;
$full_name = $entry->full_name;
$email = $entry->email;
$resume = $entry->resume;
$motivational_letter = $entry->motivational_letter;
@endphp

<?php
if($entry->job_id == ""){
    abort(403, 'Unauthorized action.');
} ?>

<div>
    <?php
    if($full_name != ""){ 
        echo '<p><b>Full Name</b>: '.$full_name.'</p>';
    }

    if($email != ""){ 
        echo '<p><b>Email</b>: '.$email.'</p>';
    }

    if($resume != ""){ 
        $doc_url = url('/').'/uploads/job-documents/'.$job_id.'/'.$resume;
        echo '<p><b>Resume</b>: <a href="'.$doc_url.'" target="_blank">OPEN</a></p>';
    }

    if($motivational_letter != ""){ 
        $doc_url = url('/').'/uploads/job-documents/'.$job_id.'/'.$motivational_letter;
        echo '<p><b>Motivational Letter</b>: <a href="'.$doc_url.'" target="_blank">OPEN</a></p>';
    } ?>
</div>
@endif

{{-- HINT --}}
@if (isset($field['hint']))
<p class="help-block">{!! $field['hint'] !!}</p>
@endif
@include('crud::fields.inc.wrapper_end')

{{-- CUSTOM CSS --}}
@push('crud_fields_styles')
{{-- How to load a CSS file? --}}
@basset('show_verification_docsFieldStyle.css')

{{-- How to add some CSS? --}}
@bassetBlock('backpack/crud/fields/show_verification_docs_field-style.css')
<style>
    .show_verification_docs_field_class {
        display: none;
    }
</style>
@endBassetBlock
@endpush

{{-- CUSTOM JS --}}
@push('crud_fields_scripts')
{{-- How to load a JS file? --}}
@basset('show_verification_docsFieldScript.js')

{{-- How to add some JS to the field? --}}
@bassetBlock('path/to/script.js')
<script>
    function bpFieldInitDummyFieldElement(element) {
            // this function will be called on pageload, because it's
            // present as data-init-function in the HTML above; the
            // element parameter here will be the jQuery wrapped
            // element where init function was defined
        console.log(element.val());
    }
</script>
@endBassetBlock
@endpush
