<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateListingPublicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('listing_publications', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('listing_id');
	    $table->text('title');
            $table->text('url');
	    $table->text('medium');
            $table->date('date_published')->nullable();
	    $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('listing_publications');
    }
}
