function bpFieldInitSelect2MultipleElement(element) {

    var $select_all = element.attr('data-select-all');
    if (!element.hasClass("select2-hidden-accessible"))
    {
        let $isFieldInline = element.data('field-is-inline');
        let $allowClear = element.data('allows-null');
        let $multiple = element.attr('multiple') ?? false;
        let $placeholder = element.attr('placeholder');

        var $obj = element.select2({
            theme: "bootstrap",
            allowClear: $allowClear,
            multiple: $multiple,
            placeholder: $placeholder,
            dropdownParent: $isFieldInline ? $('#inline-create-dialog .modal-content') : $(document.body)
        });

        //get options ids stored in the field.
        var options = JSON.parse(element.attr('data-options-for-js'));

        if($select_all) {
            element.parent().find('.clear').on("click", function () {
                $obj.val([]).trigger("change");
            });
            element.parent().find('.select_all').on("click", function () {
                $obj.val(options).trigger("change");
            });
        }
    }
}

        