<?php
    $field['value'] = old_empty_or_null($field['name'], '') ?? $field['value'] ?? $field['default'] ?? '';
    $field['config'] = array_merge([
        'shouldDoGeoIpLookup' => !$field['value'],
        'initialCountry' => 'auto',
        'separateDialCode' => true,
        'nationalMode' => true,
        'autoHideDialCode' => false,
        'placeholderNumberType' => 'MOBILE',
        'utilsScript' => 'https://unpkg.com/intl-tel-input@17.0.19/build/js/utils.js',
        'hiddenInput' => $field['name'],
        'customContainer' => '',
    ], $field['config'] ?? []);
?>

<?php echo $__env->make('crud::fields.inc.wrapper_start', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <label><?php echo $field['label']; ?></label>

    <?php echo $__env->make('crud::fields.inc.translatable_icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <input
        type="tel"
        data-config="<?php echo e(json_encode($field['config'])); ?>"
        bp-field-main-input
        data-init-function="bpFieldInitPhoneElement"
        value="<?php echo e($field['value']); ?>"
        <?php echo $__env->make('crud::fields.inc.attributes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    >
    
    <?php if(isset($field['hint'])): ?>
        <p class="help-block"><?php echo $field['hint']; ?></p>
    <?php endif; ?>
<?php echo $__env->make('crud::fields.inc.wrapper_end', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>





    
    <?php $__env->startPush('crud_fields_styles'); ?>
        
        <?php Basset::basset('https://unpkg.com/intl-tel-input@17.0.19/build/img/flags.png', false, [], false); ?>
        <?php Basset::basset('https://unpkg.com/intl-tel-input@17.0.19/build/img/flags@2x.png', false, [], false); ?>
        <?php Basset::basset('https://unpkg.com/intl-tel-input@17.0.19/build/css/intlTelInput.min.css'); ?>
        <?php $bassetBlock = 'backpack/pro/fields/phone-field.css'; ob_start(); ?>
        <style>
        .iti { width: 100%; margin-bottom: 0rem !important;}
        .iti__country-name, .iti__selected-dial-code { color: #1b2a4e !important; }
        .iti__country-list { z-index: 3!important; }
        </style>
        <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>
    <?php $__env->stopPush(); ?>

    
    <?php $__env->startPush('crud_fields_scripts'); ?>
        
        <?php Basset::basset('https://unpkg.com/intl-tel-input@17.0.19/build/js/intlTelInput.min.js'); ?>
        <?php $bassetBlock = 'backpack/pro/fields/phone-field.js'; ob_start(); ?>
        <script>
            function bpFieldInitPhoneElement(element) {
                let $phoneConfig = element.data('config');

                var input = element[0];
                var countryCode = 'us';

                if($phoneConfig.shouldDoGeoIpLookup) {
                    $phoneConfig.geoIpLookup = function(success, failure) {
                        $.get('https://ipinfo.io', function() {}, 'jsonp').always(function(resp) {
                            countryCode = (resp && resp.country) ? resp.country : countryCode;
                            success(countryCode);
                        });
                    }
                }

                /* Init phone object */
                var iti = window.intlTelInput(input, $phoneConfig);

                iti.promise.then(function() {
                    // if the phone input is empty, let's at least select the prefix to the IP country
                    if ($phoneConfig.shouldDoGeoIpLookup && input.value.trim().length <= 0) {
                        iti.setCountry(countryCode);
                    }

                    //Fix error classes
                    if(element.parent().find('.invalid-feedback').length > 0) {
                        let error = element.parent().find('.invalid-feedback');
                        $(error).appendTo(element.parent().parent());
                        element.parent().find('.invalid-feedback').remove();
                        element.parent().removeClass('text-danger');
                        element.parent().parent().addClass('text-danger');
                    }
                });
            }
        </script>
        <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>
    <?php $__env->stopPush(); ?>



<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/vendor/backpack/pro/fields/phone.blade.php ENDPATH**/ ?>