<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class ReferEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $referal;
    /**
     * Create a new message instance.
     */
    public function __construct($referal)
    {
        $this->referal = $referal;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Legal Referal | Legal.com',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {

        return new Content(
            view: 'emails.referral',
        );


    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }

    public function build()
    {
        $this->subject('Legal Referal | Legal.com')
        ->from('no-reply@legal.com')
        ->view('emails.referral')
        ->with(['user' => $this->referal]);

        return $this;
    }

}
