<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\County;
use App\Models\State;

class CountyController extends Controller
{
    public function index(Request $request)
    {
        $search_term = $request->input('q');
        $form = collect($request->input('form'))->pluck('value', 'name');

        // if no state has been selected, show no options
        if (! $form['state']) {
            return [];
        }

        if ($form['state']) {
            $state_name = State::where('id', '=', $form['state'])->first();
            $state_name = $state_name->name;
        }

        if ($search_term!="" && $state_name != ""){
            $results = County::where('name', 'LIKE', '%'.$search_term.'%')->where('state_name', 'LIKE', '%'.$state_name.'%')->orderby('name','ASC')->where('type', '=', 'County')->paginate(10);
        }else{
            $results = County::where('type', '=', 'County')->paginate(10);
        }

        return $results;
    }
}