<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use SimpleXMLElement;
use App\Models\Firm;
use App\Models\PracticeArea;
use App\Models\Listing;
use App\Models\Address;
use App\Models\Jurisdiction;
use App\Models\Language;
use App\Models\State;

use Carbon\Carbon;

class ImportListingsJustiaB extends Command
{

    protected $signature = 'import:listings_justia_b';
    protected $description = 'Import Listings from Justia';

	public function handle()
    	{
	//$state = $this->argument('state');
    	//$xml = "/home/bitnami/htdocs/legal.com/app/Console/Commands/imports/{$state}.xml";
	$xml = simplexml_load_file('/home/bitnami/htdocs/development.legal.com/app/Console/Commands/imports/justia2.xml');
        // Iterate over each <record></record> element
	$i = 0;
        foreach ($xml as $record) {
	    $i++;
	    $id = $i;
            // Extract data from the XML element
            $full_name = (string) $record['full_name'];
            $first_name = (string) $record->first_name;
	    $last_name = (string) $record->last_name;
	    $middle_name = (string) $record->middle_name;
	    $email = (string) $record->email;
	    $phone = (string) $record->phone;
	    $address = (string) $record->address;
	    $city = (string) $record->city;
	    $county = (string) $record->county;
	    $website = (string) $record->website_url;
	    $firm = (string) $record->law_firm;
	    $date_admitted = (string) $record->date_admitted;
	    $practice_areas = (string) $record->practice_areas;
	    $state_abbreviation = (string) $record->state;
	    $state_name = (string) $record->state_name;
	    $languages = (string) $record->language;
	    $jurisdictions = (string) $record->other_jurisdictions;

            if (!isset($practice_areas) || ($practice_areas == '')) {
                echo "$full_name has no practice area, skipping.\n";
            } else {
                echo "Practice areas: $practice_areas \n";

$address = trim($address);
$lines = preg_split('/\r\n|\r|\n/', $address); // Splitting the address into lines

$parsedAddress = [
    'establishment' => '',
    'po_box' => '',
    'street_address' => '',
    'city' => '',
    'state' => '',
    'zip' => ''
];

foreach ($lines as $line) {
    $line = trim($line);

    // Check for P.O. Box
    if (preg_match('/P\.O\. Box \d+/', $line)) {
        $parsedAddress['po_box'] = $line;
    } 
    // Check for City, State, and ZIP
    elseif (preg_match('/(.*),\s*(\w{2})\s*(\d{5}(-\d{4})?)/', $line, $matches)) {
        $parsedAddress['city'] = trim($matches[1]);
        $parsedAddress['state'] = $matches[2];
        $parsedAddress['zip'] = $matches[3];

        if (isset($parsedAddress['state'])) {
       		$state = State::where('abbreviation',  $matches[2])->first();
		if (isset($state->name) && ($state->name != '')) {
			$parsedAddress['state'] = $state->name;
		}
        }

    }
    // Assume the remaining part is either establishment or street address
    else {
        if (empty($parsedAddress['establishment'])) {
            $parsedAddress['establishment'] = $line;
        } else {
            $parsedAddress['street_address'] = $line;
        }
    }
}
print_r($parsedAddress);


	    echo "Listing ID: $id" . PHP_EOL;
            echo "Full Name: $full_name" . PHP_EOL;
	    echo "Address: " . print_r($address) . PHP_EOL;
	    echo "City: $city" . PHP_EOL;
            echo "County: $county" . PHP_EOL;
            echo "Website: $website" . PHP_EOL;
            echo "Firm: $firm" . PHP_EOL;
            echo "Practice areas: $practice_areas" . PHP_EOL;
	    $createdAt = date('Y-m-d H:i:s');

if (isset($address['establishment']) && !empty($address['establishment'])) {
    // Keywords to check for
    $keywords = ['LLC', 'Law', 'Legal', 'Group'];

    // Check if any keyword exists in the establishment string
    $containsKeyword = false;
    foreach ($keywords as $keyword) {
        if (stripos($address['establishment'], $keyword) !== false) {
            $containsKeyword = true;
            break;
        }
    }

    // Create a new firm if a keyword is found
    if ($containsKeyword) {
        $firm = Firm::firstOrCreate([
            'name' => $address['establishment'],
        ]);
    }
}


            // Create a new Listing
            $listing = Listing::create([
                'picture'          => null,
                'first_name'       => $first_name,
                'middle_name'      => $middle_name,
                'last_name'        => $last_name,
                'firm_id'          => isset($firm->id) ? $firm->id : null,
                'phone'            => $phone,
                'email'            => $email,
                'user_id'          => '1',
                'url' => $website,
		'created_at'	   => $createdAt,
            ]);

           if (!is_null($practice_areas) && $practice_areas !== '') {
                $practiceAreaList = explode(',', $practice_areas);

                foreach ($practiceAreaList as $practiceAreaName) {
                    $practiceAreaName = trim($practiceAreaName); 

                    if (!empty($practiceAreaName)) {
                        $practiceArea = PracticeArea::firstOrCreate([
                            'name' => $practiceAreaName
                        ]);
			$listing->practiceAreas()->attach($practiceArea->id);
                    }
                }
            }
           if (!is_null($languages) && $languages !== '') {
                $languagesList = explode(',', $languages);

                foreach ($languagesList as $lang) {
                    $languageName = trim($lang);

                    if (!empty($languageName)) {
                        $language = Language::firstOrCreate([
                            'name' => $languageName
                        ]);
			$listing->language()->attach($language);
                    }
                }
            } else {
		$language = Language::firstOrCreate([
                	'name' => 'English',
                ]);

		$listing->language()->attach($language);
            }


	   if (isset($parsedAddress['city']) && ($parsedAddress['city'] != '')) {
		$fullAddress = '';
		if (isset($address['street_address']) && isset($address['po_box'])) {
			$fullAddress = $address['street_address'] . ', ' . $address['po_box'];
		} elseif (isset($address['street_address'])) {
    			$fullAddress = $address['street_address'];
		} elseif (isset($address['po_box'])) {
			$fullAddress = $address['po_box'];
		} else {
			$fullAddress = $parsedAddress['establishment'] . ', ' . $parsedAddress['street_address'];
		}
		   $address = Address::create([
			'listing_id'	=> $listing->id,
			'label'		=> 'Office',
			'full_address'	=> $fullAddress,
			'city'		=> $parsedAddress['city'],
			'county'	=> '',
			'state' 	=> $state_name,
			'country'	=> 'United States of America',
			'zipcode'	=> $parsedAddress['zip'],
			'primary' 	=> 1,
			'created_at'	=> $createdAt,
		    ]);
	   }

	   if (isset($date_admitted) && ($date_admitted != '')) {
		$year = Carbon::createFromFormat('m/d/Y', $date_admitted)->year;
	   } else {
		$year = null;
	   }
           if (isset($jurisdictions) && ($jurisdictions != '')) {
		$jurisdictionData = explode(",", $jurisdictions);

		foreach($jurisdictionData as $jurisdictionLine) {
			$state = State::where('name',  $jurisdictionLine)->first();
                	if (isset($state->name) && ($state->name != '')) {
		        	$jurisdiction = Jurisdiction::create([
		                	'listing_id'    => $listing->id,
		                	'name'          => 'State of ' . $state->name,
		                	'since'         => $year,
		                	'created_at'    => $createdAt,
	           		]);
			} else {
                                $jurisdiction = Jurisdiction::create([
                                        'listing_id'    => $listing->id,
                                        'name'          => $jurisdictionLine,
                                        'since'         => $year,
                                        'created_at'    => $createdAt,
                                ]);
			}
		  }
		}
	   }
		
        }
        return Command::SUCCESS;
    }
}
