$(document).ready(function(){
	// Claim your profile modal popup
	$('.claim-your-profile-btn').click(function(){
		$('.h-home-wapper').addClass('moblie-search-active');
		$("#h_search_type").val("claim");
		$('.search-popup .form-group input[type="search"]').val("a").keyup();
	});

	// HIDE ERRORS ON LOAD
	jQuery("#sing-up-form-modal .err").text("");
	jQuery("#sing-up-form-modal .err").fadeOut();
	jQuery("#sing-up-form-modal .form_res").fadeOut();
	jQuery("#sing-up-form-modal .form_res #form_loading").fadeOut();
	jQuery("#sing-up-form-modal .form_res #user_form_message").fadeOut();

	function u_errorFadeIn(text,ele) {
		jQuery(ele).parent().find(".err").fadeIn();
		jQuery(".err").css("color", "#b70c0c");
		jQuery(ele).parent().find(".err").html(text);
		setTimeout(() => {
			jQuery(".err").fadeOut();
		}, 5000);
		return false;
	}

	function u_errorFadeOut() {
		jQuery("#sing-up-form-modal .err").fadeOut();
		jQuery("#sing-up-form-modal .err").css("color", "#fff");
		jQuery("#sing-up-form-modal .err").text("");
	}

	// CHECK IS EMAIL
	function u_isEmail(email) {
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		return regex.test(email);
	}

	// SHOW HIDE PASSWORD
	jQuery('#user_pass_view').click(function(){
		if('password' == jQuery('#user_password').attr('type')){
			jQuery('#user_password').prop('type', 'text');
		}else{
			jQuery('#user_password').prop('type', 'password');
		}
	});

	// FORM SUBMISSION
	$("#user_submit").click(function (e) {
		e.preventDefault();
		$("#f_user_form").submit();
	});

	$("#f_user_form").submit(function (e) {
		e.preventDefault();
		var user_name = $("#f_user_form #user_name").val();
		var user_email = $("#f_user_form #user_email").val();
		var user_password = $("#f_user_form #user_password").val();

		if (user_name.length == 0 || user_name.length < 2) {
			u_errorFadeIn("Enter valid name.","#f_user_form #user_name");
		}else if (user_email.length == 0) {
			u_errorFadeIn("Enter your email addresss","#f_user_form #user_email");
		}else if(!u_isEmail(user_email)){
			u_errorFadeIn("Enter valid email addresss","#f_user_form #user_email");
		}else if (user_password.length == 0 || user_password.length < 5) {
			u_errorFadeIn("Enter valid password. It should be 4 character long","#f_user_form #user_password");
		}else {
			u_errorFadeOut(".error");
			jQuery(".form_res").fadeIn();
			jQuery(".form_res #form_loading").fadeIn();

			$("#f_user_form").css("opacity", "0.8");
			const formData = new FormData();
			formData.append("user_name", $("#f_user_form #user_name").val());
			formData.append("user_email", $("#f_user_form #user_email").val());
			formData.append("user_password", $("#f_user_form #user_password").val());
			ajaxSend(formData, user_register);
		}
	});

	function ajaxSend(data, url) {
		$.ajaxSetup({
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		});
		$("#user_submit").attr("disabled", true);
		$.ajax({
			url: url,
			type: "POST",
			data: data,
			processData: false,
			contentType: false,
			success: function (response) {
				var response = JSON.parse(response);

				jQuery(".form_res #form_loading").fadeOut();

				if(response.error == ""){
					jQuery(".form_res #user_form_message").text(response.success);
					jQuery(".form_res #user_form_message").fadeIn();

					setTimeout(function(){ 
						jQuery(".err").text("");
						jQuery(".err").fadeOut();
						jQuery(".form_res").fadeOut();
						jQuery(".form_res #user_form_message").text("");
						jQuery(".form_res #user_form_message").fadeOut();

						$('#sing-up-form-modal').modal('hide');
						$('#login-form-modal').modal('show');
					}, 2000);
				}else{
					$("#user_submit").attr("disabled", false);
					jQuery("#f_user_form").css("opacity", "1");
					jQuery(".form_res").fadeOut();

					if(response.e_code == "e_exists"){
						u_errorFadeIn(response.error,"#user_email");
					}
				}
			},
		});
	}

	// RESEND VERIFICATION EMAIL
	jQuery("body").on("click change", "#resend_verification", function (e) {
		e.preventDefault();

		$.ajaxSetup({
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		});
		const formData = new FormData();
		formData.append("email", $("#f_user_form #user_email").val());

		$.ajax({
			url: r_verify,
			type: "POST",
			data: formData,
			processData: false,
			contentType: false,
			success: function (response) {
				var response = JSON.parse(response);

				jQuery("#login-form-modal .form_res #form_loading").fadeOut();

				if(response.error == ""){
					u_errorFadeIn(response.message,"#user_email");
				}else{
					$("#user_submit").attr("disabled", false);
					jQuery("#f_user_form").css("opacity", "1");
					jQuery(".form_res").fadeOut();

					if(response.e_code == "e"){
						u_errorFadeIn(response.error,"#user_email");
					}
				}
			},
		});
	});
})