

<li filter-name="<?php echo e($filter->name); ?>"
    filter-type="<?php echo e($filter->type); ?>"
    filter-key="<?php echo e($filter->key); ?>"
	class="nav-item dropdown <?php echo e(Request::get($filter->name) ? 'active' : ''); ?>">
	<a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown" data-bs-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><?php echo e($filter->label); ?> <span class="caret"></span></a>
	<div class="dropdown-menu p-0">
		<div class="form-group backpack-filter mb-0">
			<div class="input-group">
		        <input class="form-control pull-right"
		        		id="text-filter-<?php echo e($filter->key); ?>"
		        		type="text"
						<?php if($filter->currentValue): ?>
							value="<?php echo e($filter->currentValue); ?>"
						<?php endif; ?>
		        		>
                <a class="input-group-text text-filter-<?php echo e($filter->key); ?>-clear-button" href=""><i class="la la-times"></i></a>
		    </div>
		</div>
	</div>
</li>


<?php $__env->startPush('crud_list_scripts'); ?>
  <script>
		jQuery(document).ready(function($) {
            var shouldUpdateUrl = false;
			// focus on the input when filter is open
			$('li[filter-key=<?php echo e($filter->key); ?>] a').on('click', function(e) {
				setTimeout(() => {
					$('#text-filter-<?php echo e($filter->key); ?>').focus();
				}, 50);
			});

			$('#text-filter-<?php echo e($filter->key); ?>').on('change', function(e) {

				var parameter = '<?php echo e($filter->name); ?>';
				var value = $(this).val();

				var new_url = updateDatatablesOnFilterChange(parameter, value, value || shouldUpdateUrl);
				shouldUpdateUrl = false;

				// mark this filter as active in the navbar-filters
				if (URI(new_url).hasQuery('<?php echo e($filter->name); ?>', true)) {
					$('li[filter-key=<?php echo e($filter->key); ?>]').removeClass('active').addClass('active');
				} else {
					$('li[filter-key=<?php echo e($filter->key); ?>]').trigger('filter:clear');
				}
			});

			$('li[filter-key=<?php echo e($filter->key); ?>]').on('filter:clear', function(e) {
				$('li[filter-key=<?php echo e($filter->key); ?>]').removeClass('active');
				$('#text-filter-<?php echo e($filter->key); ?>').val('');
			});

			// clear button for text filter
			$(".text-filter-<?php echo e($filter->key); ?>-clear-button").click(function(e) {
				e.preventDefault();
                // when clicking this button this is the only removed filter, so we should update the url in this specific scenario.
                shouldUpdateUrl = true;
				$('li[filter-key=<?php echo e($filter->key); ?>]').trigger('filter:clear');
				$('#text-filter-<?php echo e($filter->key); ?>').val('');
				$('#text-filter-<?php echo e($filter->key); ?>').trigger('change');
			})
		});
  </script>
<?php $__env->stopPush(); ?>


<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/vendor/backpack/pro/filters/text.blade.php ENDPATH**/ ?>