

<?php

    // the field should work whether or not Laravel attribute casting is used
    if (isset($field['value']) && (is_array($field['value']) || is_object($field['value']))) {
        $field['value'] = json_encode($field['value']);
    }

    $field['store_as_json'] = $field['store_as_json'] ?? false;
    $field_language = $field['language'] ?? \App::getLocale();

?>

<?php echo $__env->make('crud::fields.inc.wrapper_start', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <label><?php echo $field['label']; ?></label>
    <?php echo $__env->make('crud::fields.inc.translatable_icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <input type="hidden"
           value="<?php echo e(old_empty_or_null($field['name'], '') ??  $field['value'] ?? $field['default'] ?? ''); ?>"
           name="<?php echo e($field['name']); ?>">

    <?php if(isset($field['prefix']) || isset($field['suffix'])): ?>
        <div class="input-group"> <?php endif; ?>
            <?php if(isset($field['prefix'])): ?>
                <div class="input-group-addon"><?php echo $field['prefix']; ?></div> <?php endif; ?>
                <input
                    type="text"
                    data-google-address="{&quot;field&quot;: &quot;<?php echo e($field['name']); ?>&quot;, &quot;full&quot;: <?php echo e(isset($field['store_as_json']) && $field['store_as_json'] ? 'true' : 'false'); ?> }"
                    data-init-function="bpFieldInitAddressGoogleElement"
                    data-store-as-json="<?php echo e(isset($field['store_as_json']) && $field['store_as_json'] ? 'true' : 'false'); ?>"
                    <?php echo $__env->make('crud::fields.inc.attributes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                >
            <?php if(isset($field['suffix'])): ?>
                <div class="input-group-addon"><?php echo $field['suffix']; ?></div> <?php endif; ?>
            <?php if(isset($field['prefix']) || isset($field['suffix'])): ?> </div> <?php endif; ?>

    
    <?php if(isset($field['hint'])): ?>
        <p class="help-block"><?php echo $field['hint']; ?></p>
    <?php endif; ?>
<?php echo $__env->make('crud::fields.inc.wrapper_end', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>







    
    <?php $__env->startPush('crud_fields_styles'); ?>
    <?php $bassetBlock = 'backpack/pro/fields/address-google-field.css'; ob_start(); ?>
        <style>
            .ap-input-icon.ap-icon-pin {
                right: 5px !important;
            }

            .ap-input-icon.ap-icon-clear {
                right: 10px !important;
            }

            .pac-container {
                z-index: 1051;
            }
        </style>
    <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>
    <?php $__env->stopPush(); ?>

    
    <?php $__env->startPush('crud_fields_scripts'); ?>
        <?php $bassetBlock = 'backpack/pro/fields/address-google-field.js'; ob_start(); ?>
        <script>

            function bpFieldInitAddressGoogleElement(element) {

                //this script is async loaded so it does not prevent other scripts in page to load while this is fetched from outside url.
                //at somepoint our initialization script might run before the script is on page throwing undesired errors.
                //this makes sure that when this script is run, it has google available either on our field initialization or when the callback function is called.
                if(typeof google === "undefined") { return; }

                var $addressConfig = element.data('google-address');

                var $storeAsJson = element.data('store-as-json');
                var $field = $(element).parent().children('input[type=hidden]');
            
                if ($field.val() && $field.val().length) {
                    try {
                        var existingData = JSON.parse($field.val());
                        element.val(existingData.value);
                    } catch(error) {
                        element.val($field.val());
                    }
                }

                var $autocomplete = new google.maps.places.Autocomplete(
                    (element[0]),
                    {types: ['geocode']});

                $autocomplete.addListener('place_changed', function fillInAddress() {
                    var place = $autocomplete.getPlace();
                    var value = element.val();
                    var latlng = place.geometry.location;
                    var data = {"value": value, "latlng": latlng};

                    for (var i = 0; i < place.address_components.length; i++) {
                        var addressType = place.address_components[i].types[0];
                        data[addressType] = place.address_components[i]['long_name'];
                    }

                    if($storeAsJson) {
                        $field.val(JSON.stringify(data));
                    } else {
                        $field.val(value);
                    }
                    $field.trigger('change');
                });

                $field.on('CrudField:disable', function() {
                    element.attr('disabled', 'disabled');
                });

                $field.on('CrudField:enable', function() {
                    element.removeAttr('disabled');
                });

                element.change(function(){
                    if(!$storeAsJson) {
                        $field.val(element.val());
                    } else {
                        if (!element.val().length) {
                            $field.val("");
                        }
                    }
                });
                
                element.keydown(function(e) {
                    if ($('.pac-container').is(':visible') && e.keyCode == 13) {
                        e.preventDefault();
                        return false;
                    }
                });

                // Make sure pac container is closed on modals (inline create)
                let modal = document.querySelector('.modal-dialog');
                if(modal) modal.addEventListener('click', e => document.querySelector('.pac-container').style.display = "none");
            }

            //Function that will be called by Google Places Library
            if (typeof initGoogleAddressAutocomplete === "undefined") {
                function initGoogleAddressAutocomplete() {
                    $('[data-google-address]').each(function () {
                        var element = $(this);
                        var functionName = element.data('init-function');

                        if (typeof window[functionName] === "function") {
                        window[functionName](element);
                        }
                    });
                }
            }
        </script>
        <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>

        <?php if(! Basset::isLoaded('google_places_api_script')) { Basset::markAsLoaded('google_places_api_script'); ?>
            <script src="https://maps.googleapis.com/maps/api/js?v=3&key=<?php echo e($field['api_key'] ?? config('services.google_places.key')); ?>&libraries=places&callback=initGoogleAddressAutocomplete&language=<?php echo e($field_language); ?>" async defer></script>
        <?php } ?>
    <?php $__env->stopPush(); ?>



<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/vendor/backpack/pro/fields/address_google.blade.php ENDPATH**/ ?>