<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateListingLinksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('listing_links', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('listing_id');
	    $table->enum('type', ['website', 'blog']);
            $table->text('title')->nullable();
	    $table->text('url');
            $table->date('date_published')->nullable();
	    $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('listing_links');
    }
}
