
<?php
    $field['extra_plugins'] = isset($field['extra_plugins']) ? implode(',', $field['extra_plugins']) : "";

    $defaultOptions = [
        "language" => app()->getLocale(),
        "filebrowserBrowseUrl" => backpack_url('elfinder/ckeditor'),
        "extraPlugins" => $field['extra_plugins'],
        "embed_provider" => "//ckeditor.iframe.ly/api/oembed?url={url}&callback={callback}",
    ];

    $field['options'] = array_merge($defaultOptions, $field['options'] ?? []);
?>

<?php echo $__env->make('crud::fields.inc.wrapper_start', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <label><?php echo $field['label']; ?></label>
    <?php echo $__env->make('crud::fields.inc.translatable_icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <textarea
        name="<?php echo e($field['name']); ?>"
        data-init-function="bpFieldInitCKEditorElement"
        data-options="<?php echo e(trim(json_encode($field['options']))); ?>"
        bp-field-main-input
        <?php echo $__env->make('crud::fields.inc.attributes', ['default_class' => 'form-control'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    	><?php echo e(old_empty_or_null($field['name'], '') ??  $field['value'] ?? $field['default'] ?? ''); ?></textarea>

    
    <?php if(isset($field['hint'])): ?>
        <p class="help-block"><?php echo $field['hint']; ?></p>
    <?php endif; ?>
<?php echo $__env->make('crud::fields.inc.wrapper_end', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>






    
    <?php $__env->startPush('crud_fields_scripts'); ?>
        <?php if(isset($field['custom_build'])): ?>
            <?php $__currentLoopData = $field['custom_build']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $script): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php Basset::basset($script); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <?php Basset::basset('https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js'); ?>

            <?php $bassetBlock = 'backpack/pro/fields/ckeditor.js'; ob_start(); ?>
            <script>
                async function bpFieldInitCKEditorElement(element) {
                    let ckeditor = await ClassicEditor.create(element[0], element.data('options'));
                    if(!ckeditor) return;

                    element.on('CrudField:delete', function(e) {
                        ckeditor.destroy();
                    });

                    // trigger the change event on textarea when ckeditor changes
                    ckeditor.editing.view.document.on('layoutChanged', function(e) {
                        element.trigger('change');
                    });

                    element.on('CrudField:disable', function(e) {
                        ckeditor.enableReadOnlyMode('CrudField');
                    });

                    element.on('CrudField:enable', function(e) {
                        ckeditor.disableReadOnlyMode('CrudField');
                    });
                }
            </script>
            <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>
        <?php endif; ?>
    <?php $__env->stopPush(); ?>



<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/vendor/backpack/pro/fields/ckeditor.blade.php ENDPATH**/ ?>