@include('header')

<link rel="stylesheet" type="text/css" href="css/about-us-page.css">

<!-- about banner section css start -->
<section class="about-banner-main-wapper">
    <div class="about-banner-wapper"
    style="background: linear-gradient(0deg, rgba(0, 0, 0, 0.60) 0%, rgba(0, 0, 0, 0.60) 100%), url('img/about-banner-img.png'), lightgray 50% / cover no-repeat;">
    <div class="container w-1280">
        <div class="about-text-wapper">
            <h1><?php echo $page->title; ?> </h1>
            <?php echo $page->extras['section_1_content']; ?>
        </div>
    </div>
</div>
<!-- about section b html start -->
<div class="about-section-b-wapper">
    <div class="container w-1280">
        <div class="row">
            <?php 
            $sec_2_points = $page->extras['section_2'];
            if (!empty($sec_2_points)) { 
                foreach($sec_2_points as $s2_p){ ?>
                    <div class="col-12 col-md-6 col-lg-3 mb-4 mb-lg-0">
                        <div class="about-us-card">
                            <div class="about-us-img">
                                <img src="<?php echo $s2_p['about_point_img']; ?>" alt="">
                            </div>
                            <div class="about-us-text">
                                <h3><?php echo $s2_p['about_point_title']; ?></h3>
                                <p><?php echo $s2_p['about_point_details']; ?></p>
                            </div>
                        </div>
                    </div>
                <?php } 
            } ?>
        </div>

        <div class="about-review-wapper">
            <div class="about-review-title">
                <h2><?php echo $page->extras['section_3_title']; ?></h2>
            </div>

            <div class="row">
                <?php 
                $sec_3_points = $page->extras['section_3_reviews'];
                if (!empty($sec_3_points)) { 
                    foreach($sec_3_points as $s3_p){ ?>
                        <div class="col-12 col-md-6 mb-4 mb-md-0">
                            <div class="about-review-card">
                                <p><?php echo $s3_p['review_description']; ?></p>
                                <div class="about-reviews-bottom">
                                    <h4><?php echo $s3_p['review_name']; ?></h4>
                                    <span class="about-reviews-stars-rating" rating="<?php echo $s3_p['rate_stars']; ?>">
                                        <span class="star"></span>
                                        <span class="star"></span>
                                        <span class="star"></span>
                                        <span class="star"></span>
                                        <span class="star"></span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php } 
                } ?>
            </div>
        </div>
    </div>
</div>
<!-- about section b html start -->
</section>
<!-- about banner section css end -->

<!-- Legal Guides section start -->
<div class="lelgal-guides-section">
    <div class="container w-1280">

        <?php
        $faqs = $page->extras['section_4_faqs'];
        if($page->extras['section_4_title'] != "" || !empty($faqs)){ ?>
            <div class="learn-about-wapper">
                <div class="learn-about-text">
                    <h2><?php echo $page->extras['section_4_title']; ?></h2>
                    <?php echo $page->extras['section_4_description']; ?>
                </div>

                <?php 
                if (!empty($faqs)) { ?>
                    <div class="review-faq-wapper">
                        <div class="faq-accordion-wapper">
                            <?php 
                            foreach($faqs as $faq){ ?>
                                <div class="faq-accordion-item">
                                    <div class="d-flex align-items-baseline faq-menu">
                                        <a href="javascript:void(0)"><?php echo $faq['faq_title']; ?></a>
                                    </div>
                                    <div class="faq-content" style="">
                                        <?php echo $faq['faq_description']; ?>
                                    </div>
                                </div>
                                <?php 
                            } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>

        <?php } ?>
        
        <!-- <div class="Legal-Guides-wapper">
            <h2>Legal <span>Guides</span></h2>
            <div class="injured-law-wapper legal-guides">
                <div class="Injury-Law-card-wapper">
                    <h6><a href="content-page.html">Injury Law</a></h6>
                    <p>Car Accidents, Medical Malpractice...</p>
                </div>
                <div class="Injury-Law-card-wapper">
                    <h6><a href="content-page.html">Family Law</a></h6>
                    <p>Car Accidents, Medical Malpractice...</p>
                </div>
            </div>
            <div class="read-more-btn">
                <a href="javascript:void(0)" id="legal-guides">Load more</a>
            </div>
        </div> -->

        <?php if(!empty($p_areas)){ ?>
            <div class="Legal-Guides-wapper" style="display: none;">
                <h2>Legal Research and <span>Law Practice</span></h2>
                <div class="injured-law-wapper legal-research-card">
                    <?php foreach($p_areas as $p_a_k => $p_a){ ?>
                        <div class="Injury-Law-card-wapper">
                            <h6><a href="lawyers/{{strtolower(str_replace(' ', '-', $p_a_k))}}"><?php echo $p_a_k; ?></a></h6>
                            <!-- <p><?php // echo implode(', ', array_slice($p_a, 0, 2)); ?>...</p> -->
                        </div>
                    <?php } ?>
                </div>
                <div class="read-more-btn">
                    <a href="javascript:void(0)" id="legal-research-card">Load more</a>
                </div>
            </div>
        <?php } ?>

    </div>
</div>
<!-- Legal Guides section end -->

<script src="js/about-us-page.js"></script>

@include('footer')
