<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class MergeZipFiles extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'zip:merge';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Merge the contents of the latest two ZIP files in storage';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Get the list of files in the storage directory
        $files = Storage::files('backups/Laravel');

        // Sort the files by name (latest first)
        rsort($files);

        // Get the paths of the latest two ZIP files
        $latestZipFiles = array_slice($files, 0, 3);

        // Get the name of the latest ZIP file among the two
        $latestZip = head($latestZipFiles);
        $zipFilename = basename($latestZip);

        // Create a new ZIP archive with the same name
        $mergedZipPath = storage_path('app/backups/Laravel/' . $zipFilename);
        $zip = new ZipArchive();
        if ($zip->open($mergedZipPath, ZipArchive::CREATE) !== true) {
            $this->error('Failed to create ZIP archive.');
            return;
        }

        // Iterate over the latest two ZIP files
        foreach ($latestZipFiles as $file) {
            // Read the contents of the ZIP file
            $contents = Storage::get($file);

            // Get the name of the file without the directory
            $filename = basename($file);

            // Add the contents to the new ZIP archive
            $zip->addFromString($filename, $contents);
        }

        // Close the new ZIP archive
        $zip->close();

        $this->info('Merged ZIP files successfully into: ' . $zipFilename);
    }
}
