<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\UserRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Backpack\PermissionManager\app\Http\Controllers\UserCrudController as BackpackUserCrudController;
use Backpack\PermissionManager\app\Models\Permission;
use Illuminate\Facades\Support\DB;
use setTabs;
class UserCrudController extends BackpackUserCrudController{

    public function setupListOperation()
    {
        // This takes care to add all fields from the package. If you need some field removed you could use CRUD::removeField
        parent::setupListOperation();
       
        CRUD::addFilter([
            'type' => 'text',
            'name' => 'years_of_experience',
            'label'=> 'Lawyaer Filetr by Experience'
        ]);
   
    }
    
    public function setupUpdateOperation()
    {
        
        parent::setupUpdateOperation();

      
         $user = auth()->user();
         if (!$user->hasRole('Administrator')) {
            CRUD::removeField('roles,permissions');
            CRUD::field([ 
                'label' => trans('backpack::permissionmanager.roles'),
                'name'             => 'roles', // the method that defines the relationship in your Model
                'entity'           => 'roles', // the method that defines the relationship in your Model
                'entity_secondary' => 'permissions', // the method that defines the relationship in your Model
                'attribute'        => 'name', // foreign key attribute that is shown to user
                'model'            => config('permission.models.role'), // foreign key model
                'pivot'            => true, // on create&update, do you need to add/delete pivot table entries?]
                'number_columns'   => 3, //can be 1,2,3,4,6
                'type'              => 'checklist',
            ]);
         }

        // METAS
        CRUD::field([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_title',
            'label'    => "Meta Title",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_description',
            'label'    => "Meta Description",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_keywords',
            'label'    => "Meta Keywords",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]); 

        // CONTENT
        CRUD::field([ 
            'name'  => 'slug',
            'label' => 'Slug',
            'type'  => 'text',
            'tab' => 'Content',
        ]);

        CRUD::field([
            'label'        => "Profile Picture",
            'name'         => "profile_picture",
            'filename'     => null,
            'type'         => 'base64_image',
            'aspect_ratio' => 1,
            'crop'         => false,
            'src'          => NULL,
            'tab' => 'Content',
        ]);

        CRUD::field([
            'name'  => 'content',
            'label' => 'Content',
            'type'  => 'summernote',
            'wrapper' => [
                'class' => 'form-group col-md-12',
            ],
            'tab' => 'Content',
        ]);

        CRUD::field([ 
            'name'  => 'facebook_link',
            'label' => 'Facebook Link',
            'type'  => 'url',
            'tab' => 'Content',
        ]);

        CRUD::field([ 
            'name'  => 'linkedin_link',
            'label' => 'Linkedin Link',
            'type'  => 'url',
            'tab' => 'Content',
        ]);

        CRUD::field([ 
            'name'  => 'twitter_link',
            'label' => 'Twitter Link',
            'type'  => 'url',
            'tab' => 'Content',
        ]);

    
        CRUD::addField([
            'name' => 'years_of_experience',
            'label' => 'Lawyaer Filetr by Experience',
            'type' => 'number',
        ]);
        
                 
       
    }

    public function store()
    {
       
        $response = parent::store();
  
        if($response){
            $user = auth()->user();
            $user = $this->crud->entry;
            if (isset($user->id) && $user->hasRole('Lawyer')) {
                $user->years_of_experience = $this->crud->getRequest()->input('years_of_experience');
                $user->save();
            }

            $role = Role::latest()->firstOrFail();
            $modelId = $user->id;
            $existingRole = DB::table('model_has_roles')
                                ->where('role_id', $role->id)
                                ->where('model_type', 'App\Models\User')
                                ->where('model_id', $modelId)
                                ->exists();
            if (!$existingRole) {
                DB::table('model_has_roles')->insert([
                    'role_id' => $role->id,
                    'model_type' => 'App\Models\User',
                    'model_id' => $modelId,
                ]);
            }
            return $response;
        }
        
    }

    //pending this because after discussion code is active

    // public function setupCreateOperation(){
    //     parent::setupCreateOperation();
    //     $user = auth()->user();
    //     if (!$user->hasRole('Administrator')) {
    //        CRUD::removeField('roles,permissions');
    //        CRUD::field([ 
    //            'label' => trans('backpack::permissionmanager.roles'),
    //            'name'             => 'roles', // the method that defines the relationship in your Model
    //            'entity'           => 'roles', // the method that defines the relationship in your Model
    //            'entity_secondary' => 'permissions', // the method that defines the relationship in your Model
    //            'attribute'        => 'name', // foreign key attribute that is shown to user
    //            'model'            => config('permission.models.role'), // foreign key model
    //            'pivot'            => true, // on create&update, do you need to add/delete pivot table entries?]
    //            'number_columns'   => 3, //can be 1,2,3,4,6
    //            'type'              => 'checklist',
    //        ]);
    //     }
    // }

    public function setupCreateOperation(){
        parent::setupCreateOperation();
        $user = auth()->user();
        
         if ($user->hasRole('Lawyer')) {
            CRUD::field([
                'name' => 'years_of_experience',
                'label' => 'Lawyaer Filetr by Experience',
                'type' => 'number',
            ]);
         }  
    }

    protected function filterList(Request $request)
    {
        $this->crud->addClause('whereHas', 'roles', function($query) {
            $query->where('name', 'Lawyer');
        });

        if ($request->input('years_of_experience')) {
            $years_of_experience = $request->input('years_of_experience');
            $this->crud->addClause('where', 'years_of_experience', $years_of_experience);
        }
    }

   

}